<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Criteria StructType
 * Meta information extracted from the WSDL
 * - documentation: Conditions which must be met for an extra to be bookable e.g. age of passenger, booking of parent extra.
 * @subpackage Structs
 */
class Criteria extends AbstractStructBase
{
    /**
     * The MinimumAge
     * Meta information extracted from the WSDL
     * - documentation: The minimum age qualification for an extra.
     * - use: optional
     * @var int
     */
    public $MinimumAge;
    /**
     * The MaximumAge
     * Meta information extracted from the WSDL
     * - documentation: The maximum age qualification for an extra.
     * - use: optional
     * @var int
     */
    public $MaximumAge;
    /**
     * The YearsExperience
     * Meta information extracted from the WSDL
     * - documentation: The minimum number of years of experience required to book this extra e.g. driving experiience for car rental.
     * - use: optional
     * @var int
     */
    public $YearsExperience;
    /**
     * The DateRequiredInd
     * Meta information extracted from the WSDL
     * - documentation: When 'true', a date must be supplied for the Extra request.
     * - use: optional
     * @var bool
     */
    public $DateRequiredInd;
    /**
     * The DurationRequiredInd
     * Meta information extracted from the WSDL
     * - documentation: When 'true', a duration must be supplied for the Extra request.
     * - use: optional
     * @var bool
     */
    public $DurationRequiredInd;
    /**
     * The StockControlledInd
     * Meta information extracted from the WSDL
     * - documentation: When 'true', the availabilty of this extra needs to be checked; when 'false' the extra is available.
     * - use: optional
     * @var bool
     */
    public $StockControlledInd;
    /**
     * The MaximumOccupancy
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of people permitted for this extra (e.g. car occupancy)
     * - use: optional
     * @var int
     */
    public $MaximumOccupancy;
    /**
     * Constructor method for Criteria
     * @uses Criteria::setMinimumAge()
     * @uses Criteria::setMaximumAge()
     * @uses Criteria::setYearsExperience()
     * @uses Criteria::setDateRequiredInd()
     * @uses Criteria::setDurationRequiredInd()
     * @uses Criteria::setStockControlledInd()
     * @uses Criteria::setMaximumOccupancy()
     * @param int $minimumAge
     * @param int $maximumAge
     * @param int $yearsExperience
     * @param bool $dateRequiredInd
     * @param bool $durationRequiredInd
     * @param bool $stockControlledInd
     * @param int $maximumOccupancy
     */
    public function __construct($minimumAge = null, $maximumAge = null, $yearsExperience = null, $dateRequiredInd = null, $durationRequiredInd = null, $stockControlledInd = null, $maximumOccupancy = null)
    {
        $this
            ->setMinimumAge($minimumAge)
            ->setMaximumAge($maximumAge)
            ->setYearsExperience($yearsExperience)
            ->setDateRequiredInd($dateRequiredInd)
            ->setDurationRequiredInd($durationRequiredInd)
            ->setStockControlledInd($stockControlledInd)
            ->setMaximumOccupancy($maximumOccupancy);
    }
    /**
     * Get MinimumAge value
     * @return int|null
     */
    public function getMinimumAge()
    {
        return $this->MinimumAge;
    }
    /**
     * Set MinimumAge value
     * @param int $minimumAge
     * @return \StructType\Criteria
     */
    public function setMinimumAge($minimumAge = null)
    {
        // validation for constraint: int
        if (!is_null($minimumAge) && !(is_int($minimumAge) || ctype_digit($minimumAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumAge, true), gettype($minimumAge)), __LINE__);
        }
        $this->MinimumAge = $minimumAge;
        return $this;
    }
    /**
     * Get MaximumAge value
     * @return int|null
     */
    public function getMaximumAge()
    {
        return $this->MaximumAge;
    }
    /**
     * Set MaximumAge value
     * @param int $maximumAge
     * @return \StructType\Criteria
     */
    public function setMaximumAge($maximumAge = null)
    {
        // validation for constraint: int
        if (!is_null($maximumAge) && !(is_int($maximumAge) || ctype_digit($maximumAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumAge, true), gettype($maximumAge)), __LINE__);
        }
        $this->MaximumAge = $maximumAge;
        return $this;
    }
    /**
     * Get YearsExperience value
     * @return int|null
     */
    public function getYearsExperience()
    {
        return $this->YearsExperience;
    }
    /**
     * Set YearsExperience value
     * @param int $yearsExperience
     * @return \StructType\Criteria
     */
    public function setYearsExperience($yearsExperience = null)
    {
        // validation for constraint: int
        if (!is_null($yearsExperience) && !(is_int($yearsExperience) || ctype_digit($yearsExperience))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($yearsExperience, true), gettype($yearsExperience)), __LINE__);
        }
        $this->YearsExperience = $yearsExperience;
        return $this;
    }
    /**
     * Get DateRequiredInd value
     * @return bool|null
     */
    public function getDateRequiredInd()
    {
        return $this->DateRequiredInd;
    }
    /**
     * Set DateRequiredInd value
     * @param bool $dateRequiredInd
     * @return \StructType\Criteria
     */
    public function setDateRequiredInd($dateRequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($dateRequiredInd) && !is_bool($dateRequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dateRequiredInd, true), gettype($dateRequiredInd)), __LINE__);
        }
        $this->DateRequiredInd = $dateRequiredInd;
        return $this;
    }
    /**
     * Get DurationRequiredInd value
     * @return bool|null
     */
    public function getDurationRequiredInd()
    {
        return $this->DurationRequiredInd;
    }
    /**
     * Set DurationRequiredInd value
     * @param bool $durationRequiredInd
     * @return \StructType\Criteria
     */
    public function setDurationRequiredInd($durationRequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($durationRequiredInd) && !is_bool($durationRequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($durationRequiredInd, true), gettype($durationRequiredInd)), __LINE__);
        }
        $this->DurationRequiredInd = $durationRequiredInd;
        return $this;
    }
    /**
     * Get StockControlledInd value
     * @return bool|null
     */
    public function getStockControlledInd()
    {
        return $this->StockControlledInd;
    }
    /**
     * Set StockControlledInd value
     * @param bool $stockControlledInd
     * @return \StructType\Criteria
     */
    public function setStockControlledInd($stockControlledInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($stockControlledInd) && !is_bool($stockControlledInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stockControlledInd, true), gettype($stockControlledInd)), __LINE__);
        }
        $this->StockControlledInd = $stockControlledInd;
        return $this;
    }
    /**
     * Get MaximumOccupancy value
     * @return int|null
     */
    public function getMaximumOccupancy()
    {
        return $this->MaximumOccupancy;
    }
    /**
     * Set MaximumOccupancy value
     * @param int $maximumOccupancy
     * @return \StructType\Criteria
     */
    public function setMaximumOccupancy($maximumOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maximumOccupancy) && !(is_int($maximumOccupancy) || ctype_digit($maximumOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumOccupancy, true), gettype($maximumOccupancy)), __LINE__);
        }
        $this->MaximumOccupancy = $maximumOccupancy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Criteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
