<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Donation credit card information.
 * @subpackage Structs
 */
class CreditCardInfo extends PaymentCardType
{
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - documentation: The donation currency code (ISO 4217.)
     * - use: required
     * @var string
     */
    public $Currency;
    /**
     * The DonationAmount
     * Meta information extracted from the WSDL
     * - documentation: The donation amount.
     * - use: required
     * @var float
     */
    public $DonationAmount;
    /**
     * Constructor method for CreditCardInfo
     * @uses CreditCardInfo::setCurrency()
     * @uses CreditCardInfo::setDonationAmount()
     * @param string $currency
     * @param float $donationAmount
     */
    public function __construct($currency = null, $donationAmount = null)
    {
        $this
            ->setCurrency($currency)
            ->setDonationAmount($donationAmount);
    }
    /**
     * Get Currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\CreditCardInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get DonationAmount value
     * @return float
     */
    public function getDonationAmount()
    {
        return $this->DonationAmount;
    }
    /**
     * Set DonationAmount value
     * @param float $donationAmount
     * @return \StructType\CreditCardInfo
     */
    public function setDonationAmount($donationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($donationAmount) && !(is_float($donationAmount) || is_numeric($donationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($donationAmount, true), gettype($donationAmount)), __LINE__);
        }
        $this->DonationAmount = $donationAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
