<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveredTraveler StructType
 * Meta information extracted from the WSDL
 * - documentation: Traveler information with individual insurance coverage details.
 * @subpackage Structs
 */
class CoveredTraveler extends SearchTravelerType
{
    /**
     * The TravelerRPH
     * Meta information extracted from the WSDL
     * - documentation: (Developer Notes) RPH references within this message: RequestCriterion/CheckedItemInfo/@TravelerRPH | A reference to a unique traveler ID specified elsewhere in this message.
     * - use: optional
     * @var string
     */
    public $TravelerRPH;
    /**
     * Constructor method for CoveredTraveler
     * @uses CoveredTraveler::setTravelerRPH()
     * @param string $travelerRPH
     */
    public function __construct($travelerRPH = null)
    {
        $this
            ->setTravelerRPH($travelerRPH);
    }
    /**
     * Get TravelerRPH value
     * @return string|null
     */
    public function getTravelerRPH()
    {
        return $this->TravelerRPH;
    }
    /**
     * Set TravelerRPH value
     * @param string $travelerRPH
     * @return \StructType\CoveredTraveler
     */
    public function setTravelerRPH($travelerRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRPH) && !is_string($travelerRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerRPH, true), gettype($travelerRPH)), __LINE__);
        }
        $this->TravelerRPH = $travelerRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoveredTraveler
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
