<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveredLuggage StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains descriptions of luggage or equipment for which the traveler has requested additional baggage/equipment coverage (if offered by the insurance plan).
 * @subpackage Structs
 */
class CoveredLuggage extends AbstractStructBase
{
    /**
     * The LuggageItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\LuggageItem[]
     */
    public $LuggageItem;
    /**
     * Constructor method for CoveredLuggage
     * @uses CoveredLuggage::setLuggageItem()
     * @param \StructType\LuggageItem[] $luggageItem
     */
    public function __construct(array $luggageItem = array())
    {
        $this
            ->setLuggageItem($luggageItem);
    }
    /**
     * Get LuggageItem value
     * @return \StructType\LuggageItem[]|null
     */
    public function getLuggageItem()
    {
        return $this->LuggageItem;
    }
    /**
     * This method is responsible for validating the values passed to the setLuggageItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLuggageItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLuggageItemForArrayConstraintsFromSetLuggageItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $coveredLuggageLuggageItemItem) {
            // validation for constraint: itemType
            if (!$coveredLuggageLuggageItemItem instanceof \StructType\LuggageItem) {
                $invalidValues[] = is_object($coveredLuggageLuggageItemItem) ? get_class($coveredLuggageLuggageItemItem) : sprintf('%s(%s)', gettype($coveredLuggageLuggageItemItem), var_export($coveredLuggageLuggageItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LuggageItem property can only contain items of type \StructType\LuggageItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LuggageItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LuggageItem[] $luggageItem
     * @return \StructType\CoveredLuggage
     */
    public function setLuggageItem(array $luggageItem = array())
    {
        // validation for constraint: array
        if ('' !== ($luggageItemArrayErrorMessage = self::validateLuggageItemForArrayConstraintsFromSetLuggageItem($luggageItem))) {
            throw new \InvalidArgumentException($luggageItemArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($luggageItem) && count($luggageItem) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($luggageItem)), __LINE__);
        }
        $this->LuggageItem = $luggageItem;
        return $this;
    }
    /**
     * Add item to LuggageItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LuggageItem $item
     * @return \StructType\CoveredLuggage
     */
    public function addToLuggageItem(\StructType\LuggageItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LuggageItem) {
            throw new \InvalidArgumentException(sprintf('The LuggageItem property can only contain items of type \StructType\LuggageItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->LuggageItem) && count($this->LuggageItem) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->LuggageItem)), __LINE__);
        }
        $this->LuggageItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoveredLuggage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
