<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coverages StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of coverage, insurance and waiver liability descriptions.
 * @subpackage Structs
 */
class Coverages extends AbstractStructBase
{
    /**
     * The Coverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Coverage[]
     */
    public $Coverage;
    /**
     * Constructor method for Coverages
     * @uses Coverages::setCoverage()
     * @param \StructType\Coverage[] $coverage
     */
    public function __construct(array $coverage = array())
    {
        $this
            ->setCoverage($coverage);
    }
    /**
     * Get Coverage value
     * @return \StructType\Coverage[]|null
     */
    public function getCoverage()
    {
        return $this->Coverage;
    }
    /**
     * This method is responsible for validating the values passed to the setCoverage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoverage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoverageForArrayConstraintsFromSetCoverage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $coveragesCoverageItem) {
            // validation for constraint: itemType
            if (!$coveragesCoverageItem instanceof \StructType\Coverage) {
                $invalidValues[] = is_object($coveragesCoverageItem) ? get_class($coveragesCoverageItem) : sprintf('%s(%s)', gettype($coveragesCoverageItem), var_export($coveragesCoverageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Coverage property can only contain items of type \StructType\Coverage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Coverage value
     * @throws \InvalidArgumentException
     * @param \StructType\Coverage[] $coverage
     * @return \StructType\Coverages
     */
    public function setCoverage(array $coverage = array())
    {
        // validation for constraint: array
        if ('' !== ($coverageArrayErrorMessage = self::validateCoverageForArrayConstraintsFromSetCoverage($coverage))) {
            throw new \InvalidArgumentException($coverageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($coverage) && count($coverage) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($coverage)), __LINE__);
        }
        $this->Coverage = $coverage;
        return $this;
    }
    /**
     * Add item to Coverage value
     * @throws \InvalidArgumentException
     * @param \StructType\Coverage $item
     * @return \StructType\Coverages
     */
    public function addToCoverage(\StructType\Coverage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Coverage) {
            throw new \InvalidArgumentException(sprintf('The Coverage property can only contain items of type \StructType\Coverage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Coverage) && count($this->Coverage) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Coverage)), __LINE__);
        }
        $this->Coverage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Coverages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
