<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverageFees StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of fees associated with this coverage, insurance or waiver. There may be multiple charges if the charge varies by vehicle type.
 * @subpackage Structs
 */
class CoverageFees extends AbstractStructBase
{
    /**
     * The CoverageFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\CoverageFee[]
     */
    public $CoverageFee;
    /**
     * Constructor method for CoverageFees
     * @uses CoverageFees::setCoverageFee()
     * @param \StructType\CoverageFee[] $coverageFee
     */
    public function __construct(array $coverageFee = array())
    {
        $this
            ->setCoverageFee($coverageFee);
    }
    /**
     * Get CoverageFee value
     * @return \StructType\CoverageFee[]|null
     */
    public function getCoverageFee()
    {
        return $this->CoverageFee;
    }
    /**
     * This method is responsible for validating the values passed to the setCoverageFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoverageFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoverageFeeForArrayConstraintsFromSetCoverageFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $coverageFeesCoverageFeeItem) {
            // validation for constraint: itemType
            if (!$coverageFeesCoverageFeeItem instanceof \StructType\CoverageFee) {
                $invalidValues[] = is_object($coverageFeesCoverageFeeItem) ? get_class($coverageFeesCoverageFeeItem) : sprintf('%s(%s)', gettype($coverageFeesCoverageFeeItem), var_export($coverageFeesCoverageFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CoverageFee property can only contain items of type \StructType\CoverageFee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CoverageFee value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverageFee[] $coverageFee
     * @return \StructType\CoverageFees
     */
    public function setCoverageFee(array $coverageFee = array())
    {
        // validation for constraint: array
        if ('' !== ($coverageFeeArrayErrorMessage = self::validateCoverageFeeForArrayConstraintsFromSetCoverageFee($coverageFee))) {
            throw new \InvalidArgumentException($coverageFeeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($coverageFee) && count($coverageFee) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($coverageFee)), __LINE__);
        }
        $this->CoverageFee = $coverageFee;
        return $this;
    }
    /**
     * Add item to CoverageFee value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverageFee $item
     * @return \StructType\CoverageFees
     */
    public function addToCoverageFee(\StructType\CoverageFee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoverageFee) {
            throw new \InvalidArgumentException(sprintf('The CoverageFee property can only contain items of type \StructType\CoverageFee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CoverageFee) && count($this->CoverageFee) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CoverageFee)), __LINE__);
        }
        $this->CoverageFee[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoverageFees
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
