<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponNumber StructType
 * Meta information extracted from the WSDL
 * - documentation: The applicable coupon number.
 * @subpackage Structs
 */
class CouponNumber extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: The coupon number.
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The TaxCouponInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxCouponInfo
     */
    public $TaxCouponInfo;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: The tax/fee charge for this coupon.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Tax;
    /**
     * The UnticketedPointInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\UnticketedPointInfo[]
     */
    public $UnticketedPointInfo;
    /**
     * Constructor method for CouponNumber
     * @uses CouponNumber::setNumber()
     * @uses CouponNumber::setTaxCouponInfo()
     * @uses CouponNumber::setTax()
     * @uses CouponNumber::setUnticketedPointInfo()
     * @param int $number
     * @param \StructType\TaxCouponInfo $taxCouponInfo
     * @param mixed[] $tax
     * @param \StructType\UnticketedPointInfo[] $unticketedPointInfo
     */
    public function __construct($number = null, \StructType\TaxCouponInfo $taxCouponInfo = null, array $tax = array(), array $unticketedPointInfo = array())
    {
        $this
            ->setNumber($number)
            ->setTaxCouponInfo($taxCouponInfo)
            ->setTax($tax)
            ->setUnticketedPointInfo($unticketedPointInfo);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\CouponNumber
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get TaxCouponInfo value
     * @return \StructType\TaxCouponInfo|null
     */
    public function getTaxCouponInfo()
    {
        return $this->TaxCouponInfo;
    }
    /**
     * Set TaxCouponInfo value
     * @param \StructType\TaxCouponInfo $taxCouponInfo
     * @return \StructType\CouponNumber
     */
    public function setTaxCouponInfo(\StructType\TaxCouponInfo $taxCouponInfo = null)
    {
        $this->TaxCouponInfo = $taxCouponInfo;
        return $this;
    }
    /**
     * Get Tax value
     * @return mixed[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponNumberTaxItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($couponNumberTaxItem) ? get_class($couponNumberTaxItem) : sprintf('%s(%s)', gettype($couponNumberTaxItem), var_export($couponNumberTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param mixed[] $tax
     * @return \StructType\CouponNumber
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($tax) && count($tax) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CouponNumber
     */
    public function addToTax($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Tax) && count($this->Tax) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Tax)), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get UnticketedPointInfo value
     * @return \StructType\UnticketedPointInfo[]|null
     */
    public function getUnticketedPointInfo()
    {
        return $this->UnticketedPointInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setUnticketedPointInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnticketedPointInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnticketedPointInfoForArrayConstraintsFromSetUnticketedPointInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponNumberUnticketedPointInfoItem) {
            // validation for constraint: itemType
            if (!$couponNumberUnticketedPointInfoItem instanceof \StructType\UnticketedPointInfo) {
                $invalidValues[] = is_object($couponNumberUnticketedPointInfoItem) ? get_class($couponNumberUnticketedPointInfoItem) : sprintf('%s(%s)', gettype($couponNumberUnticketedPointInfoItem), var_export($couponNumberUnticketedPointInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnticketedPointInfo property can only contain items of type \StructType\UnticketedPointInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnticketedPointInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\UnticketedPointInfo[] $unticketedPointInfo
     * @return \StructType\CouponNumber
     */
    public function setUnticketedPointInfo(array $unticketedPointInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($unticketedPointInfoArrayErrorMessage = self::validateUnticketedPointInfoForArrayConstraintsFromSetUnticketedPointInfo($unticketedPointInfo))) {
            throw new \InvalidArgumentException($unticketedPointInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($unticketedPointInfo) && count($unticketedPointInfo) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($unticketedPointInfo)), __LINE__);
        }
        $this->UnticketedPointInfo = $unticketedPointInfo;
        return $this;
    }
    /**
     * Add item to UnticketedPointInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\UnticketedPointInfo $item
     * @return \StructType\CouponNumber
     */
    public function addToUnticketedPointInfo(\StructType\UnticketedPointInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnticketedPointInfo) {
            throw new \InvalidArgumentException(sprintf('The UnticketedPointInfo property can only contain items of type \StructType\UnticketedPointInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->UnticketedPointInfo) && count($this->UnticketedPointInfo) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->UnticketedPointInfo)), __LINE__);
        }
        $this->UnticketedPointInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CouponNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
