<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Optional information on coupon numbers being exchanged. | The applicable free baggage allowance. UnitOfMeasureQuanity will contain either the weight or the number of pieces. | Number, status, in connection nbr, itinerary sequence
 * nbr, coupon ref, not valid before/after, involuntary indicator, and in connection qualfier.
 * @subpackage Structs
 */
class CouponInfo extends AbstractStructBase
{
    /**
     * The SoldFlightSegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to the flight segments for this coupon.
     * - minOccurs: 0
     * @var mixed
     */
    public $SoldFlightSegmentRPH;
    /**
     * The CheckedInAirlineRPH
     * Meta information extracted from the WSDL
     * - documentation: The checked-in/lifted airline information.
     * - choice: CheckedInAirlineRPH | FlownAirlineSegmentRPH
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $CheckedInAirlineRPH;
    /**
     * The ExcessBaggage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExcessBaggage
     */
    public $ExcessBaggage;
    /**
     * The PresentInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PresentInfo
     */
    public $PresentInfo;
    /**
     * The ReasonForIssuance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReasonForIssuance
     */
    public $ReasonForIssuance;
    /**
     * The ValidatingAirline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ValidatingAirline
     */
    public $ValidatingAirline;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: The applicable coupon number.
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * The InConnectionNbr
     * Meta information extracted from the WSDL
     * - documentation: The coupon number associated with the 'in connection with' document number.
     * - use: optional
     * @var int
     */
    public $InConnectionNbr;
    /**
     * The CouponReference
     * Meta information extracted from the WSDL
     * - documentation: The sequential number (segment identifier) of an individual flight segment, e.g., 1 of 3.
     * - use: optional
     * @var string
     */
    public $CouponReference;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: The applicable fare basis code.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Code providing status information for this coupon. Refer to OpenTravel Code List Status (STS).
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The CouponItinerarySeqNbr
     * Meta information extracted from the WSDL
     * - documentation: The number representing the order in which this coupon was used or is to be used.
     * - use: optional
     * @var int
     */
    public $CouponItinerarySeqNbr;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: The value associated to a single coupon of a miscellaneous document.
     * - use: optional
     * @var float
     */
    public $Value;
    /**
     * The AssociateInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the coupon should be associated. When false, it should be disassociated.
     * - use: optional
     * @var bool
     */
    public $AssociateInd;
    /**
     * The PromotionalCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify a promotional code that applies to the fee.
     * - use: optional
     * @var string
     */
    public $PromotionalCode;
    /**
     * The TaxOnEMD_Ind
     * Meta information extracted from the WSDL
     * - documentation: When true, a tax has been collected and is due to a local government from the validating carrier.
     * - use: optional
     * @var bool
     */
    public $TaxOnEMD_Ind;
    /**
     * The AssocFareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: The applicable code as provided for in IATA Resolution 728 for the associated EMD.
     * - use: optional
     * @var string
     */
    public $AssocFareBasisCode;
    /**
     * The ConsumedAtIssuanceInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the coupon is consumed at issuance.
     * - use: optional
     * @var bool
     */
    public $ConsumedAtIssuanceInd;
    /**
     * The DateOfService
     * Meta information extracted from the WSDL
     * - documentation: The scheduled date of service for this coupon of an EMD.
     * - use: optional
     * @var string
     */
    public $DateOfService;
    /**
     * The NbrOfSvcs
     * Meta information extracted from the WSDL
     * - documentation: The number of services of the same type that are included in the EMD coupon.
     * @var int
     */
    public $NbrOfSvcs;
    /**
     * The FlownAirlineSegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to the flight segments for this coupon
     * - choice: CheckedInAirlineRPH | FlownAirlineSegmentRPH
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $FlownAirlineSegmentRPH;
    /**
     * The FiledFeeInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FiledFeeInfo
     */
    public $FiledFeeInfo;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: The starting value of the time span.
     * - use: optional
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: The duration datatype represents a combination of year, month, day and time values representing a single duration of time, encoded as a single string.
     * - use: optional
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: The ending value of the time span.
     * - use: optional
     * @var string
     */
    public $End;
    /**
     * The InvoluntaryIndCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InvoluntaryIndCode;
    /**
     * The SettlementAuthCode
     * Meta information extracted from the WSDL
     * - documentation: A reference number generated by the validating carrier authorising settlment of a coupon.
     * - use: optional
     * @var string
     */
    public $SettlementAuthCode;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Free text describing the service on the EMD.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * Constructor method for CouponInfo
     * @uses CouponInfo::setSoldFlightSegmentRPH()
     * @uses CouponInfo::setCheckedInAirlineRPH()
     * @uses CouponInfo::setExcessBaggage()
     * @uses CouponInfo::setPresentInfo()
     * @uses CouponInfo::setReasonForIssuance()
     * @uses CouponInfo::setValidatingAirline()
     * @uses CouponInfo::setNumber()
     * @uses CouponInfo::setInConnectionNbr()
     * @uses CouponInfo::setCouponReference()
     * @uses CouponInfo::setFareBasisCode()
     * @uses CouponInfo::setStatus()
     * @uses CouponInfo::setCouponItinerarySeqNbr()
     * @uses CouponInfo::setValue()
     * @uses CouponInfo::setAssociateInd()
     * @uses CouponInfo::setPromotionalCode()
     * @uses CouponInfo::setTaxOnEMD_Ind()
     * @uses CouponInfo::setAssocFareBasisCode()
     * @uses CouponInfo::setConsumedAtIssuanceInd()
     * @uses CouponInfo::setDateOfService()
     * @uses CouponInfo::setNbrOfSvcs()
     * @uses CouponInfo::setFlownAirlineSegmentRPH()
     * @uses CouponInfo::setFiledFeeInfo()
     * @uses CouponInfo::setStart()
     * @uses CouponInfo::setDuration()
     * @uses CouponInfo::setEnd()
     * @uses CouponInfo::setInvoluntaryIndCode()
     * @uses CouponInfo::setSettlementAuthCode()
     * @uses CouponInfo::setRemark()
     * @param mixed $soldFlightSegmentRPH
     * @param mixed $checkedInAirlineRPH
     * @param \StructType\ExcessBaggage $excessBaggage
     * @param \StructType\PresentInfo $presentInfo
     * @param \StructType\ReasonForIssuance $reasonForIssuance
     * @param \StructType\ValidatingAirline $validatingAirline
     * @param int $number
     * @param int $inConnectionNbr
     * @param string $couponReference
     * @param string $fareBasisCode
     * @param string $status
     * @param int $couponItinerarySeqNbr
     * @param float $value
     * @param bool $associateInd
     * @param string $promotionalCode
     * @param bool $taxOnEMD_Ind
     * @param string $assocFareBasisCode
     * @param bool $consumedAtIssuanceInd
     * @param string $dateOfService
     * @param int $nbrOfSvcs
     * @param mixed $flownAirlineSegmentRPH
     * @param \StructType\FiledFeeInfo $filedFeeInfo
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $involuntaryIndCode
     * @param string $settlementAuthCode
     * @param string $remark
     */
    public function __construct($soldFlightSegmentRPH = null, $checkedInAirlineRPH = null, \StructType\ExcessBaggage $excessBaggage = null, \StructType\PresentInfo $presentInfo = null, \StructType\ReasonForIssuance $reasonForIssuance = null, \StructType\ValidatingAirline $validatingAirline = null, $number = null, $inConnectionNbr = null, $couponReference = null, $fareBasisCode = null, $status = null, $couponItinerarySeqNbr = null, $value = null, $associateInd = null, $promotionalCode = null, $taxOnEMD_Ind = null, $assocFareBasisCode = null, $consumedAtIssuanceInd = null, $dateOfService = null, $nbrOfSvcs = null, $flownAirlineSegmentRPH = null, \StructType\FiledFeeInfo $filedFeeInfo = null, $start = null, $duration = null, $end = null, $involuntaryIndCode = null, $settlementAuthCode = null, $remark = null)
    {
        $this
            ->setSoldFlightSegmentRPH($soldFlightSegmentRPH)
            ->setCheckedInAirlineRPH($checkedInAirlineRPH)
            ->setExcessBaggage($excessBaggage)
            ->setPresentInfo($presentInfo)
            ->setReasonForIssuance($reasonForIssuance)
            ->setValidatingAirline($validatingAirline)
            ->setNumber($number)
            ->setInConnectionNbr($inConnectionNbr)
            ->setCouponReference($couponReference)
            ->setFareBasisCode($fareBasisCode)
            ->setStatus($status)
            ->setCouponItinerarySeqNbr($couponItinerarySeqNbr)
            ->setValue($value)
            ->setAssociateInd($associateInd)
            ->setPromotionalCode($promotionalCode)
            ->setTaxOnEMD_Ind($taxOnEMD_Ind)
            ->setAssocFareBasisCode($assocFareBasisCode)
            ->setConsumedAtIssuanceInd($consumedAtIssuanceInd)
            ->setDateOfService($dateOfService)
            ->setNbrOfSvcs($nbrOfSvcs)
            ->setFlownAirlineSegmentRPH($flownAirlineSegmentRPH)
            ->setFiledFeeInfo($filedFeeInfo)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setInvoluntaryIndCode($involuntaryIndCode)
            ->setSettlementAuthCode($settlementAuthCode)
            ->setRemark($remark);
    }
    /**
     * Get SoldFlightSegmentRPH value
     * @return mixed|null
     */
    public function getSoldFlightSegmentRPH()
    {
        return $this->SoldFlightSegmentRPH;
    }
    /**
     * Set SoldFlightSegmentRPH value
     * @param mixed $soldFlightSegmentRPH
     * @return \StructType\CouponInfo
     */
    public function setSoldFlightSegmentRPH($soldFlightSegmentRPH = null)
    {
        $this->SoldFlightSegmentRPH = $soldFlightSegmentRPH;
        return $this;
    }
    /**
     * Get CheckedInAirlineRPH value
     * @return mixed|null
     */
    public function getCheckedInAirlineRPH()
    {
        return isset($this->CheckedInAirlineRPH) ? $this->CheckedInAirlineRPH : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCheckedInAirlineRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckedInAirlineRPH method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCheckedInAirlineRPHForChoiceConstraintsFromSetCheckedInAirlineRPH($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'FlownAirlineSegmentRPH',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CheckedInAirlineRPH can\'t be set as the property %s is already set. Only one property must be set among these properties: CheckedInAirlineRPH, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CheckedInAirlineRPH value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $checkedInAirlineRPH
     * @return \StructType\CouponInfo
     */
    public function setCheckedInAirlineRPH($checkedInAirlineRPH = null)
    {
        // validation for constraint: choice(CheckedInAirlineRPH, FlownAirlineSegmentRPH)
        if ('' !== ($checkedInAirlineRPHChoiceErrorMessage = self::validateCheckedInAirlineRPHForChoiceConstraintsFromSetCheckedInAirlineRPH($checkedInAirlineRPH))) {
            throw new \InvalidArgumentException($checkedInAirlineRPHChoiceErrorMessage, __LINE__);
        }
        if (is_null($checkedInAirlineRPH) || (is_array($checkedInAirlineRPH) && empty($checkedInAirlineRPH))) {
            unset($this->CheckedInAirlineRPH);
        } else {
            $this->CheckedInAirlineRPH = $checkedInAirlineRPH;
        }
        return $this;
    }
    /**
     * Get ExcessBaggage value
     * @return \StructType\ExcessBaggage|null
     */
    public function getExcessBaggage()
    {
        return $this->ExcessBaggage;
    }
    /**
     * Set ExcessBaggage value
     * @param \StructType\ExcessBaggage $excessBaggage
     * @return \StructType\CouponInfo
     */
    public function setExcessBaggage(\StructType\ExcessBaggage $excessBaggage = null)
    {
        $this->ExcessBaggage = $excessBaggage;
        return $this;
    }
    /**
     * Get PresentInfo value
     * @return \StructType\PresentInfo|null
     */
    public function getPresentInfo()
    {
        return $this->PresentInfo;
    }
    /**
     * Set PresentInfo value
     * @param \StructType\PresentInfo $presentInfo
     * @return \StructType\CouponInfo
     */
    public function setPresentInfo(\StructType\PresentInfo $presentInfo = null)
    {
        $this->PresentInfo = $presentInfo;
        return $this;
    }
    /**
     * Get ReasonForIssuance value
     * @return \StructType\ReasonForIssuance|null
     */
    public function getReasonForIssuance()
    {
        return $this->ReasonForIssuance;
    }
    /**
     * Set ReasonForIssuance value
     * @param \StructType\ReasonForIssuance $reasonForIssuance
     * @return \StructType\CouponInfo
     */
    public function setReasonForIssuance(\StructType\ReasonForIssuance $reasonForIssuance = null)
    {
        $this->ReasonForIssuance = $reasonForIssuance;
        return $this;
    }
    /**
     * Get ValidatingAirline value
     * @return \StructType\ValidatingAirline|null
     */
    public function getValidatingAirline()
    {
        return $this->ValidatingAirline;
    }
    /**
     * Set ValidatingAirline value
     * @param \StructType\ValidatingAirline $validatingAirline
     * @return \StructType\CouponInfo
     */
    public function setValidatingAirline(\StructType\ValidatingAirline $validatingAirline = null)
    {
        $this->ValidatingAirline = $validatingAirline;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\CouponInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get InConnectionNbr value
     * @return int|null
     */
    public function getInConnectionNbr()
    {
        return $this->InConnectionNbr;
    }
    /**
     * Set InConnectionNbr value
     * @param int $inConnectionNbr
     * @return \StructType\CouponInfo
     */
    public function setInConnectionNbr($inConnectionNbr = null)
    {
        // validation for constraint: int
        if (!is_null($inConnectionNbr) && !(is_int($inConnectionNbr) || ctype_digit($inConnectionNbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inConnectionNbr, true), gettype($inConnectionNbr)), __LINE__);
        }
        $this->InConnectionNbr = $inConnectionNbr;
        return $this;
    }
    /**
     * Get CouponReference value
     * @return string|null
     */
    public function getCouponReference()
    {
        return $this->CouponReference;
    }
    /**
     * Set CouponReference value
     * @param string $couponReference
     * @return \StructType\CouponInfo
     */
    public function setCouponReference($couponReference = null)
    {
        // validation for constraint: string
        if (!is_null($couponReference) && !is_string($couponReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponReference, true), gettype($couponReference)), __LINE__);
        }
        $this->CouponReference = $couponReference;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\CouponInfo
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\CouponInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CouponItinerarySeqNbr value
     * @return int|null
     */
    public function getCouponItinerarySeqNbr()
    {
        return $this->CouponItinerarySeqNbr;
    }
    /**
     * Set CouponItinerarySeqNbr value
     * @param int $couponItinerarySeqNbr
     * @return \StructType\CouponInfo
     */
    public function setCouponItinerarySeqNbr($couponItinerarySeqNbr = null)
    {
        // validation for constraint: int
        if (!is_null($couponItinerarySeqNbr) && !(is_int($couponItinerarySeqNbr) || ctype_digit($couponItinerarySeqNbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponItinerarySeqNbr, true), gettype($couponItinerarySeqNbr)), __LINE__);
        }
        $this->CouponItinerarySeqNbr = $couponItinerarySeqNbr;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\CouponInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get AssociateInd value
     * @return bool|null
     */
    public function getAssociateInd()
    {
        return $this->AssociateInd;
    }
    /**
     * Set AssociateInd value
     * @param bool $associateInd
     * @return \StructType\CouponInfo
     */
    public function setAssociateInd($associateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($associateInd) && !is_bool($associateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($associateInd, true), gettype($associateInd)), __LINE__);
        }
        $this->AssociateInd = $associateInd;
        return $this;
    }
    /**
     * Get PromotionalCode value
     * @return string|null
     */
    public function getPromotionalCode()
    {
        return $this->PromotionalCode;
    }
    /**
     * Set PromotionalCode value
     * @param string $promotionalCode
     * @return \StructType\CouponInfo
     */
    public function setPromotionalCode($promotionalCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionalCode) && !is_string($promotionalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionalCode, true), gettype($promotionalCode)), __LINE__);
        }
        $this->PromotionalCode = $promotionalCode;
        return $this;
    }
    /**
     * Get TaxOnEMD_Ind value
     * @return bool|null
     */
    public function getTaxOnEMD_Ind()
    {
        return $this->TaxOnEMD_Ind;
    }
    /**
     * Set TaxOnEMD_Ind value
     * @param bool $taxOnEMD_Ind
     * @return \StructType\CouponInfo
     */
    public function setTaxOnEMD_Ind($taxOnEMD_Ind = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxOnEMD_Ind) && !is_bool($taxOnEMD_Ind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxOnEMD_Ind, true), gettype($taxOnEMD_Ind)), __LINE__);
        }
        $this->TaxOnEMD_Ind = $taxOnEMD_Ind;
        return $this;
    }
    /**
     * Get AssocFareBasisCode value
     * @return string|null
     */
    public function getAssocFareBasisCode()
    {
        return $this->AssocFareBasisCode;
    }
    /**
     * Set AssocFareBasisCode value
     * @param string $assocFareBasisCode
     * @return \StructType\CouponInfo
     */
    public function setAssocFareBasisCode($assocFareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($assocFareBasisCode) && !is_string($assocFareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assocFareBasisCode, true), gettype($assocFareBasisCode)), __LINE__);
        }
        $this->AssocFareBasisCode = $assocFareBasisCode;
        return $this;
    }
    /**
     * Get ConsumedAtIssuanceInd value
     * @return bool|null
     */
    public function getConsumedAtIssuanceInd()
    {
        return $this->ConsumedAtIssuanceInd;
    }
    /**
     * Set ConsumedAtIssuanceInd value
     * @param bool $consumedAtIssuanceInd
     * @return \StructType\CouponInfo
     */
    public function setConsumedAtIssuanceInd($consumedAtIssuanceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($consumedAtIssuanceInd) && !is_bool($consumedAtIssuanceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($consumedAtIssuanceInd, true), gettype($consumedAtIssuanceInd)), __LINE__);
        }
        $this->ConsumedAtIssuanceInd = $consumedAtIssuanceInd;
        return $this;
    }
    /**
     * Get DateOfService value
     * @return string|null
     */
    public function getDateOfService()
    {
        return $this->DateOfService;
    }
    /**
     * Set DateOfService value
     * @param string $dateOfService
     * @return \StructType\CouponInfo
     */
    public function setDateOfService($dateOfService = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfService) && !is_string($dateOfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfService, true), gettype($dateOfService)), __LINE__);
        }
        $this->DateOfService = $dateOfService;
        return $this;
    }
    /**
     * Get NbrOfSvcs value
     * @return int|null
     */
    public function getNbrOfSvcs()
    {
        return $this->NbrOfSvcs;
    }
    /**
     * Set NbrOfSvcs value
     * @param int $nbrOfSvcs
     * @return \StructType\CouponInfo
     */
    public function setNbrOfSvcs($nbrOfSvcs = null)
    {
        // validation for constraint: int
        if (!is_null($nbrOfSvcs) && !(is_int($nbrOfSvcs) || ctype_digit($nbrOfSvcs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbrOfSvcs, true), gettype($nbrOfSvcs)), __LINE__);
        }
        $this->NbrOfSvcs = $nbrOfSvcs;
        return $this;
    }
    /**
     * Get FlownAirlineSegmentRPH value
     * @return mixed|null
     */
    public function getFlownAirlineSegmentRPH()
    {
        return isset($this->FlownAirlineSegmentRPH) ? $this->FlownAirlineSegmentRPH : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFlownAirlineSegmentRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlownAirlineSegmentRPH method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFlownAirlineSegmentRPHForChoiceConstraintsFromSetFlownAirlineSegmentRPH($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CheckedInAirlineRPH',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FlownAirlineSegmentRPH can\'t be set as the property %s is already set. Only one property must be set among these properties: FlownAirlineSegmentRPH, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FlownAirlineSegmentRPH value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $flownAirlineSegmentRPH
     * @return \StructType\CouponInfo
     */
    public function setFlownAirlineSegmentRPH($flownAirlineSegmentRPH = null)
    {
        // validation for constraint: choice(CheckedInAirlineRPH, FlownAirlineSegmentRPH)
        if ('' !== ($flownAirlineSegmentRPHChoiceErrorMessage = self::validateFlownAirlineSegmentRPHForChoiceConstraintsFromSetFlownAirlineSegmentRPH($flownAirlineSegmentRPH))) {
            throw new \InvalidArgumentException($flownAirlineSegmentRPHChoiceErrorMessage, __LINE__);
        }
        if (is_null($flownAirlineSegmentRPH) || (is_array($flownAirlineSegmentRPH) && empty($flownAirlineSegmentRPH))) {
            unset($this->FlownAirlineSegmentRPH);
        } else {
            $this->FlownAirlineSegmentRPH = $flownAirlineSegmentRPH;
        }
        return $this;
    }
    /**
     * Get FiledFeeInfo value
     * @return \StructType\FiledFeeInfo|null
     */
    public function getFiledFeeInfo()
    {
        return $this->FiledFeeInfo;
    }
    /**
     * Set FiledFeeInfo value
     * @param \StructType\FiledFeeInfo $filedFeeInfo
     * @return \StructType\CouponInfo
     */
    public function setFiledFeeInfo(\StructType\FiledFeeInfo $filedFeeInfo = null)
    {
        $this->FiledFeeInfo = $filedFeeInfo;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\CouponInfo
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\CouponInfo
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\CouponInfo
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get InvoluntaryIndCode value
     * @return string|null
     */
    public function getInvoluntaryIndCode()
    {
        return $this->InvoluntaryIndCode;
    }
    /**
     * Set InvoluntaryIndCode value
     * @param string $involuntaryIndCode
     * @return \StructType\CouponInfo
     */
    public function setInvoluntaryIndCode($involuntaryIndCode = null)
    {
        // validation for constraint: string
        if (!is_null($involuntaryIndCode) && !is_string($involuntaryIndCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($involuntaryIndCode, true), gettype($involuntaryIndCode)), __LINE__);
        }
        $this->InvoluntaryIndCode = $involuntaryIndCode;
        return $this;
    }
    /**
     * Get SettlementAuthCode value
     * @return string|null
     */
    public function getSettlementAuthCode()
    {
        return $this->SettlementAuthCode;
    }
    /**
     * Set SettlementAuthCode value
     * @param string $settlementAuthCode
     * @return \StructType\CouponInfo
     */
    public function setSettlementAuthCode($settlementAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($settlementAuthCode) && !is_string($settlementAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementAuthCode, true), gettype($settlementAuthCode)), __LINE__);
        }
        $this->SettlementAuthCode = $settlementAuthCode;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\CouponInfo
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CouponInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
