<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Conversion StructType
 * Meta information extracted from the WSDL
 * - documentation: Conversion ratio amount and currency. | Conversion ratio information.
 * @subpackage Structs
 */
class Conversion extends AbstractStructBase
{
    /**
     * The Ratio
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This is the ratio used to calculate the quantity of loyalty currency to a monetary amount and unit. If not supplied, it assumes a Ratio of 1:1000. For example, a base fare of $100 USD where Ratio is 1000 requires 100,000
     * frequent flyer miles to pay for the full base fare (100 * 1000 = 100,000 miles.) | Example: 1000 | Conversion ratio.
     * - use: optional
     * @var int
     */
    public $Ratio;
    /**
     * Constructor method for Conversion
     * @uses Conversion::setRatio()
     * @param int $ratio
     */
    public function __construct($ratio = null)
    {
        $this
            ->setRatio($ratio);
    }
    /**
     * Get Ratio value
     * @return int|null
     */
    public function getRatio()
    {
        return $this->Ratio;
    }
    /**
     * Set Ratio value
     * @param int $ratio
     * @return \StructType\Conversion
     */
    public function setRatio($ratio = null)
    {
        // validation for constraint: int
        if (!is_null($ratio) && !(is_int($ratio) || ctype_digit($ratio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ratio, true), gettype($ratio)), __LINE__);
        }
        $this->Ratio = $ratio;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Conversion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
