<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompatibleOffers StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of compatible offers.
 * @subpackage Structs
 */
class CompatibleOffers extends AbstractStructBase
{
    /**
     * The CompatibleOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\CompatibleOffer[]
     */
    public $CompatibleOffer;
    /**
     * Constructor method for CompatibleOffers
     * @uses CompatibleOffers::setCompatibleOffer()
     * @param \StructType\CompatibleOffer[] $compatibleOffer
     */
    public function __construct(array $compatibleOffer = array())
    {
        $this
            ->setCompatibleOffer($compatibleOffer);
    }
    /**
     * Get CompatibleOffer value
     * @return \StructType\CompatibleOffer[]|null
     */
    public function getCompatibleOffer()
    {
        return $this->CompatibleOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setCompatibleOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompatibleOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompatibleOfferForArrayConstraintsFromSetCompatibleOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $compatibleOffersCompatibleOfferItem) {
            // validation for constraint: itemType
            if (!$compatibleOffersCompatibleOfferItem instanceof \StructType\CompatibleOffer) {
                $invalidValues[] = is_object($compatibleOffersCompatibleOfferItem) ? get_class($compatibleOffersCompatibleOfferItem) : sprintf('%s(%s)', gettype($compatibleOffersCompatibleOfferItem), var_export($compatibleOffersCompatibleOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CompatibleOffer property can only contain items of type \StructType\CompatibleOffer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CompatibleOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\CompatibleOffer[] $compatibleOffer
     * @return \StructType\CompatibleOffers
     */
    public function setCompatibleOffer(array $compatibleOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($compatibleOfferArrayErrorMessage = self::validateCompatibleOfferForArrayConstraintsFromSetCompatibleOffer($compatibleOffer))) {
            throw new \InvalidArgumentException($compatibleOfferArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($compatibleOffer) && count($compatibleOffer) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($compatibleOffer)), __LINE__);
        }
        $this->CompatibleOffer = $compatibleOffer;
        return $this;
    }
    /**
     * Add item to CompatibleOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\CompatibleOffer $item
     * @return \StructType\CompatibleOffers
     */
    public function addToCompatibleOffer(\StructType\CompatibleOffer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompatibleOffer) {
            throw new \InvalidArgumentException(sprintf('The CompatibleOffer property can only contain items of type \StructType\CompatibleOffer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CompatibleOffer) && count($this->CompatibleOffer) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CompatibleOffer)), __LINE__);
        }
        $this->CompatibleOffer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompatibleOffers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
