<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the currency to be applied to the amounts located in the child elements. | Contains details pertaining to commissions.
 * - use: optional
 * @subpackage Structs
 */
class CommissionType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: Identifies the recipient of the commission.
     * - minOccurs: 0
     * @var mixed
     */
    public $UniqueID;
    /**
     * The CommissionableAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommissionableAmount
     */
    public $CommissionableAmount;
    /**
     * The PrepaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PrepaidAmount
     */
    public $PrepaidAmount;
    /**
     * The FlatCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FlatCommission
     */
    public $FlatCommission;
    /**
     * The CommissionPayableAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommissionPayableAmount
     */
    public $CommissionPayableAmount;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Text related to the commission.
     * - minOccurs: 0
     * @var mixed
     */
    public $Comment;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The StatusType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $StatusType;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: The percent applied to the commissionable amount to determine the commission payable amount.
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the reason why a commission is not paid or not paid in full.
     * - use: optional
     * @var string
     */
    public $ReasonCode;
    /**
     * The BillToID
     * Meta information extracted from the WSDL
     * - documentation: Identifies who should be billed for the commission amount.
     * - use: optional
     * @var string
     */
    public $BillToID;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - documentation: This is the frequency at which the commission is applied (e.g. per stay, daily). Refer to OpenTravel Code List Charge Type (CHG).
     * - use: optional
     * @var string
     */
    public $Frequency;
    /**
     * The MaxCommissionUnitApplies
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of units for which the commission will be applied. This may be used in conjunction with the frequency attribute.
     * - use: optional
     * @var int
     */
    public $MaxCommissionUnitApplies;
    /**
     * The CapAmount
     * Meta information extracted from the WSDL
     * - documentation: The highest monetary value that may be paid for the commission.
     * - use: optional
     * @var float
     */
    public $CapAmount;
    /**
     * Constructor method for CommissionType
     * @uses CommissionType::setUniqueID()
     * @uses CommissionType::setCommissionableAmount()
     * @uses CommissionType::setPrepaidAmount()
     * @uses CommissionType::setFlatCommission()
     * @uses CommissionType::setCommissionPayableAmount()
     * @uses CommissionType::setComment()
     * @uses CommissionType::setTPA_Extensions()
     * @uses CommissionType::setStatusType()
     * @uses CommissionType::setPercent()
     * @uses CommissionType::setReasonCode()
     * @uses CommissionType::setBillToID()
     * @uses CommissionType::setFrequency()
     * @uses CommissionType::setMaxCommissionUnitApplies()
     * @uses CommissionType::setCapAmount()
     * @param mixed $uniqueID
     * @param \StructType\CommissionableAmount $commissionableAmount
     * @param \StructType\PrepaidAmount $prepaidAmount
     * @param \StructType\FlatCommission $flatCommission
     * @param \StructType\CommissionPayableAmount $commissionPayableAmount
     * @param mixed $comment
     * @param mixed $tPA_Extensions
     * @param string $statusType
     * @param float $percent
     * @param string $reasonCode
     * @param string $billToID
     * @param string $frequency
     * @param int $maxCommissionUnitApplies
     * @param float $capAmount
     */
    public function __construct($uniqueID = null, \StructType\CommissionableAmount $commissionableAmount = null, \StructType\PrepaidAmount $prepaidAmount = null, \StructType\FlatCommission $flatCommission = null, \StructType\CommissionPayableAmount $commissionPayableAmount = null, $comment = null, $tPA_Extensions = null, $statusType = null, $percent = null, $reasonCode = null, $billToID = null, $frequency = null, $maxCommissionUnitApplies = null, $capAmount = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setCommissionableAmount($commissionableAmount)
            ->setPrepaidAmount($prepaidAmount)
            ->setFlatCommission($flatCommission)
            ->setCommissionPayableAmount($commissionPayableAmount)
            ->setComment($comment)
            ->setTPA_Extensions($tPA_Extensions)
            ->setStatusType($statusType)
            ->setPercent($percent)
            ->setReasonCode($reasonCode)
            ->setBillToID($billToID)
            ->setFrequency($frequency)
            ->setMaxCommissionUnitApplies($maxCommissionUnitApplies)
            ->setCapAmount($capAmount);
    }
    /**
     * Get UniqueID value
     * @return mixed|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param mixed $uniqueID
     * @return \StructType\CommissionType
     */
    public function setUniqueID($uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get CommissionableAmount value
     * @return \StructType\CommissionableAmount|null
     */
    public function getCommissionableAmount()
    {
        return $this->CommissionableAmount;
    }
    /**
     * Set CommissionableAmount value
     * @param \StructType\CommissionableAmount $commissionableAmount
     * @return \StructType\CommissionType
     */
    public function setCommissionableAmount(\StructType\CommissionableAmount $commissionableAmount = null)
    {
        $this->CommissionableAmount = $commissionableAmount;
        return $this;
    }
    /**
     * Get PrepaidAmount value
     * @return \StructType\PrepaidAmount|null
     */
    public function getPrepaidAmount()
    {
        return $this->PrepaidAmount;
    }
    /**
     * Set PrepaidAmount value
     * @param \StructType\PrepaidAmount $prepaidAmount
     * @return \StructType\CommissionType
     */
    public function setPrepaidAmount(\StructType\PrepaidAmount $prepaidAmount = null)
    {
        $this->PrepaidAmount = $prepaidAmount;
        return $this;
    }
    /**
     * Get FlatCommission value
     * @return \StructType\FlatCommission|null
     */
    public function getFlatCommission()
    {
        return $this->FlatCommission;
    }
    /**
     * Set FlatCommission value
     * @param \StructType\FlatCommission $flatCommission
     * @return \StructType\CommissionType
     */
    public function setFlatCommission(\StructType\FlatCommission $flatCommission = null)
    {
        $this->FlatCommission = $flatCommission;
        return $this;
    }
    /**
     * Get CommissionPayableAmount value
     * @return \StructType\CommissionPayableAmount|null
     */
    public function getCommissionPayableAmount()
    {
        return $this->CommissionPayableAmount;
    }
    /**
     * Set CommissionPayableAmount value
     * @param \StructType\CommissionPayableAmount $commissionPayableAmount
     * @return \StructType\CommissionType
     */
    public function setCommissionPayableAmount(\StructType\CommissionPayableAmount $commissionPayableAmount = null)
    {
        $this->CommissionPayableAmount = $commissionPayableAmount;
        return $this;
    }
    /**
     * Get Comment value
     * @return mixed|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param mixed $comment
     * @return \StructType\CommissionType
     */
    public function setComment($comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\CommissionType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get StatusType value
     * @return string|null
     */
    public function getStatusType()
    {
        return $this->StatusType;
    }
    /**
     * Set StatusType value
     * @param string $statusType
     * @return \StructType\CommissionType
     */
    public function setStatusType($statusType = null)
    {
        // validation for constraint: string
        if (!is_null($statusType) && !is_string($statusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusType, true), gettype($statusType)), __LINE__);
        }
        $this->StatusType = $statusType;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\CommissionType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\CommissionType
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get BillToID value
     * @return string|null
     */
    public function getBillToID()
    {
        return $this->BillToID;
    }
    /**
     * Set BillToID value
     * @param string $billToID
     * @return \StructType\CommissionType
     */
    public function setBillToID($billToID = null)
    {
        // validation for constraint: string
        if (!is_null($billToID) && !is_string($billToID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billToID, true), gettype($billToID)), __LINE__);
        }
        $this->BillToID = $billToID;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \StructType\CommissionType
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get MaxCommissionUnitApplies value
     * @return int|null
     */
    public function getMaxCommissionUnitApplies()
    {
        return $this->MaxCommissionUnitApplies;
    }
    /**
     * Set MaxCommissionUnitApplies value
     * @param int $maxCommissionUnitApplies
     * @return \StructType\CommissionType
     */
    public function setMaxCommissionUnitApplies($maxCommissionUnitApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxCommissionUnitApplies) && !(is_int($maxCommissionUnitApplies) || ctype_digit($maxCommissionUnitApplies))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCommissionUnitApplies, true), gettype($maxCommissionUnitApplies)), __LINE__);
        }
        $this->MaxCommissionUnitApplies = $maxCommissionUnitApplies;
        return $this;
    }
    /**
     * Get CapAmount value
     * @return float|null
     */
    public function getCapAmount()
    {
        return $this->CapAmount;
    }
    /**
     * Set CapAmount value
     * @param float $capAmount
     * @return \StructType\CommissionType
     */
    public function setCapAmount($capAmount = null)
    {
        // validation for constraint: float
        if (!is_null($capAmount) && !(is_float($capAmount) || is_numeric($capAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capAmount, true), gettype($capAmount)), __LINE__);
        }
        $this->CapAmount = $capAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommissionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
