<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionPolicy StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to define the property's high-level commission policy.
 * @subpackage Structs
 */
class CommissionPolicy extends FeeType
{
    /**
     * The PaymentCompany
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\PaymentCompany[]
     */
    public $PaymentCompany;
    /**
     * The CommissionApplicability
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CommissionApplicability;
    /**
     * Constructor method for CommissionPolicy
     * @uses CommissionPolicy::setPaymentCompany()
     * @uses CommissionPolicy::setCommissionApplicability()
     * @param \StructType\PaymentCompany[] $paymentCompany
     * @param string $commissionApplicability
     */
    public function __construct(array $paymentCompany = array(), $commissionApplicability = null)
    {
        $this
            ->setPaymentCompany($paymentCompany)
            ->setCommissionApplicability($commissionApplicability);
    }
    /**
     * Get PaymentCompany value
     * @return \StructType\PaymentCompany[]|null
     */
    public function getPaymentCompany()
    {
        return $this->PaymentCompany;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentCompany method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCompany method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentCompanyForArrayConstraintsFromSetPaymentCompany(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commissionPolicyPaymentCompanyItem) {
            // validation for constraint: itemType
            if (!$commissionPolicyPaymentCompanyItem instanceof \StructType\PaymentCompany) {
                $invalidValues[] = is_object($commissionPolicyPaymentCompanyItem) ? get_class($commissionPolicyPaymentCompanyItem) : sprintf('%s(%s)', gettype($commissionPolicyPaymentCompanyItem), var_export($commissionPolicyPaymentCompanyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentCompany property can only contain items of type \StructType\PaymentCompany, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentCompany value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentCompany[] $paymentCompany
     * @return \StructType\CommissionPolicy
     */
    public function setPaymentCompany(array $paymentCompany = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentCompanyArrayErrorMessage = self::validatePaymentCompanyForArrayConstraintsFromSetPaymentCompany($paymentCompany))) {
            throw new \InvalidArgumentException($paymentCompanyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($paymentCompany) && count($paymentCompany) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($paymentCompany)), __LINE__);
        }
        $this->PaymentCompany = $paymentCompany;
        return $this;
    }
    /**
     * Add item to PaymentCompany value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentCompany $item
     * @return \StructType\CommissionPolicy
     */
    public function addToPaymentCompany(\StructType\PaymentCompany $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentCompany) {
            throw new \InvalidArgumentException(sprintf('The PaymentCompany property can only contain items of type \StructType\PaymentCompany, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PaymentCompany) && count($this->PaymentCompany) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PaymentCompany)), __LINE__);
        }
        $this->PaymentCompany[] = $item;
        return $this;
    }
    /**
     * Get CommissionApplicability value
     * @return string|null
     */
    public function getCommissionApplicability()
    {
        return $this->CommissionApplicability;
    }
    /**
     * Set CommissionApplicability value
     * @param string $commissionApplicability
     * @return \StructType\CommissionPolicy
     */
    public function setCommissionApplicability($commissionApplicability = null)
    {
        // validation for constraint: string
        if (!is_null($commissionApplicability) && !is_string($commissionApplicability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commissionApplicability, true), gettype($commissionApplicability)), __LINE__);
        }
        $this->CommissionApplicability = $commissionApplicability;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommissionPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
