<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comment StructType
 * Meta information extracted from the WSDL
 * - documentation: A comment about the air traveler. | Comment details.
 * @subpackage Structs
 */
class Comment extends FormattedTextTextType
{
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The CommentOriginatorCode
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for the system which created the comment.
     * - use: optional
     * @var string
     */
    public $CommentOriginatorCode;
    /**
     * The GuestViewable
     * Meta information extracted from the WSDL
     * - documentation: When true, the comment may be shown to the consumer. When false, the comment may not be shown to the consumer.
     * - use: optional
     * @var bool
     */
    public $GuestViewable;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the type of comment.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The AuthorizedViewer
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\AuthorizedViewer[]
     */
    public $AuthorizedViewer;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - documentation: An industry segment (e.g., Air, Hotel, Car) to which the comment refers.
     * - use: optional
     * @var string
     */
    public $Category;
    /**
     * The AirlineVendorPrefRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to an airline in AirlinePrefType/VendorPref.
     * - use: optional
     * @var string
     */
    public $AirlineVendorPrefRPH;
    /**
     * The TransferAction
     * Meta information extracted from the WSDL
     * - documentation: Indicates under what conditions this element will be transfered to the booking.
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * The ActionDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates at which date an action described in the comment must be taken.
     * - use: optional
     * @var string
     */
    public $ActionDate;
    /**
     * Constructor method for Comment
     * @uses Comment::setTPA_Extensions()
     * @uses Comment::setCommentOriginatorCode()
     * @uses Comment::setGuestViewable()
     * @uses Comment::setName()
     * @uses Comment::setAuthorizedViewer()
     * @uses Comment::setCategory()
     * @uses Comment::setAirlineVendorPrefRPH()
     * @uses Comment::setTransferAction()
     * @uses Comment::setActionDate()
     * @param mixed $tPA_Extensions
     * @param string $commentOriginatorCode
     * @param bool $guestViewable
     * @param string $name
     * @param \StructType\AuthorizedViewer[] $authorizedViewer
     * @param string $category
     * @param string $airlineVendorPrefRPH
     * @param string $transferAction
     * @param string $actionDate
     */
    public function __construct($tPA_Extensions = null, $commentOriginatorCode = null, $guestViewable = null, $name = null, array $authorizedViewer = array(), $category = null, $airlineVendorPrefRPH = null, $transferAction = null, $actionDate = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setCommentOriginatorCode($commentOriginatorCode)
            ->setGuestViewable($guestViewable)
            ->setName($name)
            ->setAuthorizedViewer($authorizedViewer)
            ->setCategory($category)
            ->setAirlineVendorPrefRPH($airlineVendorPrefRPH)
            ->setTransferAction($transferAction)
            ->setActionDate($actionDate);
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\Comment
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get CommentOriginatorCode value
     * @return string|null
     */
    public function getCommentOriginatorCode()
    {
        return $this->CommentOriginatorCode;
    }
    /**
     * Set CommentOriginatorCode value
     * @param string $commentOriginatorCode
     * @return \StructType\Comment
     */
    public function setCommentOriginatorCode($commentOriginatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($commentOriginatorCode) && !is_string($commentOriginatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentOriginatorCode, true), gettype($commentOriginatorCode)), __LINE__);
        }
        $this->CommentOriginatorCode = $commentOriginatorCode;
        return $this;
    }
    /**
     * Get GuestViewable value
     * @return bool|null
     */
    public function getGuestViewable()
    {
        return $this->GuestViewable;
    }
    /**
     * Set GuestViewable value
     * @param bool $guestViewable
     * @return \StructType\Comment
     */
    public function setGuestViewable($guestViewable = null)
    {
        // validation for constraint: boolean
        if (!is_null($guestViewable) && !is_bool($guestViewable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guestViewable, true), gettype($guestViewable)), __LINE__);
        }
        $this->GuestViewable = $guestViewable;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Comment
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AuthorizedViewer value
     * @return \StructType\AuthorizedViewer[]|null
     */
    public function getAuthorizedViewer()
    {
        return $this->AuthorizedViewer;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthorizedViewer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorizedViewer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthorizedViewerForArrayConstraintsFromSetAuthorizedViewer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commentAuthorizedViewerItem) {
            // validation for constraint: itemType
            if (!$commentAuthorizedViewerItem instanceof \StructType\AuthorizedViewer) {
                $invalidValues[] = is_object($commentAuthorizedViewerItem) ? get_class($commentAuthorizedViewerItem) : sprintf('%s(%s)', gettype($commentAuthorizedViewerItem), var_export($commentAuthorizedViewerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AuthorizedViewer property can only contain items of type \StructType\AuthorizedViewer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AuthorizedViewer value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizedViewer[] $authorizedViewer
     * @return \StructType\Comment
     */
    public function setAuthorizedViewer(array $authorizedViewer = array())
    {
        // validation for constraint: array
        if ('' !== ($authorizedViewerArrayErrorMessage = self::validateAuthorizedViewerForArrayConstraintsFromSetAuthorizedViewer($authorizedViewer))) {
            throw new \InvalidArgumentException($authorizedViewerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($authorizedViewer) && count($authorizedViewer) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($authorizedViewer)), __LINE__);
        }
        $this->AuthorizedViewer = $authorizedViewer;
        return $this;
    }
    /**
     * Add item to AuthorizedViewer value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizedViewer $item
     * @return \StructType\Comment
     */
    public function addToAuthorizedViewer(\StructType\AuthorizedViewer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AuthorizedViewer) {
            throw new \InvalidArgumentException(sprintf('The AuthorizedViewer property can only contain items of type \StructType\AuthorizedViewer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->AuthorizedViewer) && count($this->AuthorizedViewer) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->AuthorizedViewer)), __LINE__);
        }
        $this->AuthorizedViewer[] = $item;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\Comment
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get AirlineVendorPrefRPH value
     * @return string|null
     */
    public function getAirlineVendorPrefRPH()
    {
        return $this->AirlineVendorPrefRPH;
    }
    /**
     * Set AirlineVendorPrefRPH value
     * @param string $airlineVendorPrefRPH
     * @return \StructType\Comment
     */
    public function setAirlineVendorPrefRPH($airlineVendorPrefRPH = null)
    {
        // validation for constraint: string
        if (!is_null($airlineVendorPrefRPH) && !is_string($airlineVendorPrefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineVendorPrefRPH, true), gettype($airlineVendorPrefRPH)), __LINE__);
        }
        $this->AirlineVendorPrefRPH = $airlineVendorPrefRPH;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\Comment
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Get ActionDate value
     * @return string|null
     */
    public function getActionDate()
    {
        return $this->ActionDate;
    }
    /**
     * Set ActionDate value
     * @param string $actionDate
     * @return \StructType\Comment
     */
    public function setActionDate($actionDate = null)
    {
        // validation for constraint: string
        if (!is_null($actionDate) && !is_string($actionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDate, true), gettype($actionDate)), __LINE__);
        }
        $this->ActionDate = $actionDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Comment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
