<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeListSummaryExtension StructType
 * Meta information extracted from the WSDL
 * - documentation: Simple Code List extension structure that supports OpenTravel open lists and third-party code lists.
 * @subpackage Structs
 */
class CodeListSummaryExtension extends AbstractStructBase
{
    /**
     * The RemovalInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this item is obsolete and should be removed from the receiving system. | Example: false | Item removal indicator.
     * - use: optional
     * @var bool
     */
    public $RemovalInd;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Reference: http://www.iso.org/iso/home.htm | OpenTravel Best Practice for Language Designation: Unless otherwise noted, all language designations are two alpha characters and WILL follow ISO 639-1 prescribed format. | Note: This is
     * the language that the code information is specified in. | Example: en | Code information language.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Implementer: Place a code value in this attribute if you have selected the "Other_" value in the enumerated list. Note that this value should be known to your trading partners. | Example: MYB | Code value.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Example: Party Supplies | Code description.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The DescriptionDetail
     * Meta information extracted from the WSDL
     * - documentation: Example: Mylar Baloons | Code description detail.
     * - use: optional
     * @var string
     */
    public $DescriptionDetail;
    /**
     * The SourceName
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This may be a source authority/ owner name, ID or code. | Example: OpenTravel | Code authority or owner.
     * - use: optional
     * @var string
     */
    public $SourceName;
    /**
     * The SourceURL
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This is A URL to the code source authority/ owner. | Example: http://www.opentravel.org | Code authority or owner URL.
     * - use: optional
     * @var string
     */
    public $SourceURL;
    /**
     * The ResourceID
     * Meta information extracted from the WSDL
     * - documentation: Example: OTALIST | Code resource ID.
     * - use: optional
     * @var string
     */
    public $ResourceID;
    /**
     * The ResourceName
     * Meta information extracted from the WSDL
     * - documentation: Example: OpenTravel 2012A CodeList | Code resource name.
     * - use: optional
     * @var string
     */
    public $ResourceName;
    /**
     * The ResourceURL
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This is A URL to the code resource. | Example: http://www.opentravel.org/somecodelist.html | Code resource URL.
     * - use: optional
     * @var string
     */
    public $ResourceURL;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This is used for a database or key ID for the code item (if it is different from the @CodeExtension) in relationship to the obsolete code indicator. | Example: MYB123 | Code unique ID.
     * - use: optional
     * @var string
     */
    public $UniqueID;
    /**
     * Constructor method for CodeListSummaryExtension
     * @uses CodeListSummaryExtension::setRemovalInd()
     * @uses CodeListSummaryExtension::setLanguage()
     * @uses CodeListSummaryExtension::setCode()
     * @uses CodeListSummaryExtension::setDescription()
     * @uses CodeListSummaryExtension::setDescriptionDetail()
     * @uses CodeListSummaryExtension::setSourceName()
     * @uses CodeListSummaryExtension::setSourceURL()
     * @uses CodeListSummaryExtension::setResourceID()
     * @uses CodeListSummaryExtension::setResourceName()
     * @uses CodeListSummaryExtension::setResourceURL()
     * @uses CodeListSummaryExtension::setUniqueID()
     * @param bool $removalInd
     * @param string $language
     * @param string $code
     * @param string $description
     * @param string $descriptionDetail
     * @param string $sourceName
     * @param string $sourceURL
     * @param string $resourceID
     * @param string $resourceName
     * @param string $resourceURL
     * @param string $uniqueID
     */
    public function __construct($removalInd = null, $language = null, $code = null, $description = null, $descriptionDetail = null, $sourceName = null, $sourceURL = null, $resourceID = null, $resourceName = null, $resourceURL = null, $uniqueID = null)
    {
        $this
            ->setRemovalInd($removalInd)
            ->setLanguage($language)
            ->setCode($code)
            ->setDescription($description)
            ->setDescriptionDetail($descriptionDetail)
            ->setSourceName($sourceName)
            ->setSourceURL($sourceURL)
            ->setResourceID($resourceID)
            ->setResourceName($resourceName)
            ->setResourceURL($resourceURL)
            ->setUniqueID($uniqueID);
    }
    /**
     * Get RemovalInd value
     * @return bool|null
     */
    public function getRemovalInd()
    {
        return $this->RemovalInd;
    }
    /**
     * Set RemovalInd value
     * @param bool $removalInd
     * @return \StructType\CodeListSummaryExtension
     */
    public function setRemovalInd($removalInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($removalInd) && !is_bool($removalInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removalInd, true), gettype($removalInd)), __LINE__);
        }
        $this->RemovalInd = $removalInd;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\CodeListSummaryExtension
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\CodeListSummaryExtension
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\CodeListSummaryExtension
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DescriptionDetail value
     * @return string|null
     */
    public function getDescriptionDetail()
    {
        return $this->DescriptionDetail;
    }
    /**
     * Set DescriptionDetail value
     * @param string $descriptionDetail
     * @return \StructType\CodeListSummaryExtension
     */
    public function setDescriptionDetail($descriptionDetail = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionDetail) && !is_string($descriptionDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionDetail, true), gettype($descriptionDetail)), __LINE__);
        }
        $this->DescriptionDetail = $descriptionDetail;
        return $this;
    }
    /**
     * Get SourceName value
     * @return string|null
     */
    public function getSourceName()
    {
        return $this->SourceName;
    }
    /**
     * Set SourceName value
     * @param string $sourceName
     * @return \StructType\CodeListSummaryExtension
     */
    public function setSourceName($sourceName = null)
    {
        // validation for constraint: string
        if (!is_null($sourceName) && !is_string($sourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceName, true), gettype($sourceName)), __LINE__);
        }
        $this->SourceName = $sourceName;
        return $this;
    }
    /**
     * Get SourceURL value
     * @return string|null
     */
    public function getSourceURL()
    {
        return $this->SourceURL;
    }
    /**
     * Set SourceURL value
     * @param string $sourceURL
     * @return \StructType\CodeListSummaryExtension
     */
    public function setSourceURL($sourceURL = null)
    {
        // validation for constraint: string
        if (!is_null($sourceURL) && !is_string($sourceURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceURL, true), gettype($sourceURL)), __LINE__);
        }
        $this->SourceURL = $sourceURL;
        return $this;
    }
    /**
     * Get ResourceID value
     * @return string|null
     */
    public function getResourceID()
    {
        return $this->ResourceID;
    }
    /**
     * Set ResourceID value
     * @param string $resourceID
     * @return \StructType\CodeListSummaryExtension
     */
    public function setResourceID($resourceID = null)
    {
        // validation for constraint: string
        if (!is_null($resourceID) && !is_string($resourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resourceID, true), gettype($resourceID)), __LINE__);
        }
        $this->ResourceID = $resourceID;
        return $this;
    }
    /**
     * Get ResourceName value
     * @return string|null
     */
    public function getResourceName()
    {
        return $this->ResourceName;
    }
    /**
     * Set ResourceName value
     * @param string $resourceName
     * @return \StructType\CodeListSummaryExtension
     */
    public function setResourceName($resourceName = null)
    {
        // validation for constraint: string
        if (!is_null($resourceName) && !is_string($resourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resourceName, true), gettype($resourceName)), __LINE__);
        }
        $this->ResourceName = $resourceName;
        return $this;
    }
    /**
     * Get ResourceURL value
     * @return string|null
     */
    public function getResourceURL()
    {
        return $this->ResourceURL;
    }
    /**
     * Set ResourceURL value
     * @param string $resourceURL
     * @return \StructType\CodeListSummaryExtension
     */
    public function setResourceURL($resourceURL = null)
    {
        // validation for constraint: string
        if (!is_null($resourceURL) && !is_string($resourceURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resourceURL, true), gettype($resourceURL)), __LINE__);
        }
        $this->ResourceURL = $resourceURL;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return string|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param string $uniqueID
     * @return \StructType\CodeListSummaryExtension
     */
    public function setUniqueID($uniqueID = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueID) && !is_string($uniqueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueID, true), gettype($uniqueID)), __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CodeListSummaryExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
