<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeListFeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Fees associated with a code item.
 * @subpackage Structs
 */
class CodeListFeeType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Amount
     */
    public $Amount;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Fee type.
     * - minOccurs: 0
     * @var mixed
     */
    public $Type;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Implementer: The associated language identifier for this descriptive information is specified in the @Language attribute. | Fee description.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var string[]
     */
    public $Description;
    /**
     * The Qualifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Qualifiers
     */
    public $Qualifiers;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Taxes[]
     */
    public $Taxes;
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the fee is mandatory. | Example: true | Mandatory fee indicator.
     * - use: optional
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The TaxInclusiveInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, taxes have been included in the fee amount. | Example: true | Taxes included in fee indicator.
     * @var bool
     */
    public $TaxInclusiveInd;
    /**
     * The TaxableInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the fee is subject to tax. | Example: true | Fee taxable indicator.
     * - use: optional
     * @var bool
     */
    public $TaxableInd;
    /**
     * The DeterminationMethod
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DeterminationMethod;
    /**
     * The FeeRPH
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $FeeRPH;
    /**
     * Constructor method for CodeListFeeType
     * @uses CodeListFeeType::setAmount()
     * @uses CodeListFeeType::setType()
     * @uses CodeListFeeType::setDescription()
     * @uses CodeListFeeType::setQualifiers()
     * @uses CodeListFeeType::setTaxes()
     * @uses CodeListFeeType::setMandatoryInd()
     * @uses CodeListFeeType::setTaxInclusiveInd()
     * @uses CodeListFeeType::setTaxableInd()
     * @uses CodeListFeeType::setDeterminationMethod()
     * @uses CodeListFeeType::setFeeRPH()
     * @param \StructType\Amount $amount
     * @param mixed $type
     * @param string[] $description
     * @param \StructType\Qualifiers $qualifiers
     * @param \StructType\Taxes[] $taxes
     * @param bool $mandatoryInd
     * @param bool $taxInclusiveInd
     * @param bool $taxableInd
     * @param string $determinationMethod
     * @param string $feeRPH
     */
    public function __construct(\StructType\Amount $amount = null, $type = null, array $description = array(), \StructType\Qualifiers $qualifiers = null, array $taxes = array(), $mandatoryInd = null, $taxInclusiveInd = null, $taxableInd = null, $determinationMethod = null, $feeRPH = null)
    {
        $this
            ->setAmount($amount)
            ->setType($type)
            ->setDescription($description)
            ->setQualifiers($qualifiers)
            ->setTaxes($taxes)
            ->setMandatoryInd($mandatoryInd)
            ->setTaxInclusiveInd($taxInclusiveInd)
            ->setTaxableInd($taxableInd)
            ->setDeterminationMethod($determinationMethod)
            ->setFeeRPH($feeRPH);
    }
    /**
     * Get Amount value
     * @return \StructType\Amount|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\Amount $amount
     * @return \StructType\CodeListFeeType
     */
    public function setAmount(\StructType\Amount $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Type value
     * @return mixed|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param mixed $type
     * @return \StructType\CodeListFeeType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $codeListFeeTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($codeListFeeTypeDescriptionItem)) {
                $invalidValues[] = is_object($codeListFeeTypeDescriptionItem) ? get_class($codeListFeeTypeDescriptionItem) : sprintf('%s(%s)', gettype($codeListFeeTypeDescriptionItem), var_export($codeListFeeTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \StructType\CodeListFeeType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($description) && count($description) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CodeListFeeType
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Description) && count($this->Description) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Qualifiers value
     * @return \StructType\Qualifiers|null
     */
    public function getQualifiers()
    {
        return $this->Qualifiers;
    }
    /**
     * Set Qualifiers value
     * @param \StructType\Qualifiers $qualifiers
     * @return \StructType\CodeListFeeType
     */
    public function setQualifiers(\StructType\Qualifiers $qualifiers = null)
    {
        $this->Qualifiers = $qualifiers;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \StructType\Taxes[]|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxesForArrayConstraintsFromSetTaxes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $codeListFeeTypeTaxesItem) {
            // validation for constraint: itemType
            if (!$codeListFeeTypeTaxesItem instanceof \StructType\Taxes) {
                $invalidValues[] = is_object($codeListFeeTypeTaxesItem) ? get_class($codeListFeeTypeTaxesItem) : sprintf('%s(%s)', gettype($codeListFeeTypeTaxesItem), var_export($codeListFeeTypeTaxesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Taxes property can only contain items of type \StructType\Taxes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Taxes value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxes[] $taxes
     * @return \StructType\CodeListFeeType
     */
    public function setTaxes(array $taxes = array())
    {
        // validation for constraint: array
        if ('' !== ($taxesArrayErrorMessage = self::validateTaxesForArrayConstraintsFromSetTaxes($taxes))) {
            throw new \InvalidArgumentException($taxesArrayErrorMessage, __LINE__);
        }
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Add item to Taxes value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxes $item
     * @return \StructType\CodeListFeeType
     */
    public function addToTaxes(\StructType\Taxes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Taxes) {
            throw new \InvalidArgumentException(sprintf('The Taxes property can only contain items of type \StructType\Taxes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Taxes[] = $item;
        return $this;
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\CodeListFeeType
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get TaxInclusiveInd value
     * @return bool|null
     */
    public function getTaxInclusiveInd()
    {
        return $this->TaxInclusiveInd;
    }
    /**
     * Set TaxInclusiveInd value
     * @param bool $taxInclusiveInd
     * @return \StructType\CodeListFeeType
     */
    public function setTaxInclusiveInd($taxInclusiveInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusiveInd) && !is_bool($taxInclusiveInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusiveInd, true), gettype($taxInclusiveInd)), __LINE__);
        }
        $this->TaxInclusiveInd = $taxInclusiveInd;
        return $this;
    }
    /**
     * Get TaxableInd value
     * @return bool|null
     */
    public function getTaxableInd()
    {
        return $this->TaxableInd;
    }
    /**
     * Set TaxableInd value
     * @param bool $taxableInd
     * @return \StructType\CodeListFeeType
     */
    public function setTaxableInd($taxableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxableInd) && !is_bool($taxableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxableInd, true), gettype($taxableInd)), __LINE__);
        }
        $this->TaxableInd = $taxableInd;
        return $this;
    }
    /**
     * Get DeterminationMethod value
     * @return string|null
     */
    public function getDeterminationMethod()
    {
        return $this->DeterminationMethod;
    }
    /**
     * Set DeterminationMethod value
     * @param string $determinationMethod
     * @return \StructType\CodeListFeeType
     */
    public function setDeterminationMethod($determinationMethod = null)
    {
        // validation for constraint: string
        if (!is_null($determinationMethod) && !is_string($determinationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($determinationMethod, true), gettype($determinationMethod)), __LINE__);
        }
        $this->DeterminationMethod = $determinationMethod;
        return $this;
    }
    /**
     * Get FeeRPH value
     * @return string|null
     */
    public function getFeeRPH()
    {
        return $this->FeeRPH;
    }
    /**
     * Set FeeRPH value
     * @param string $feeRPH
     * @return \StructType\CodeListFeeType
     */
    public function setFeeRPH($feeRPH = null)
    {
        // validation for constraint: string
        if (!is_null($feeRPH) && !is_string($feeRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeRPH, true), gettype($feeRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($feeRPH) && !preg_match('/[0-9]{1,8}/', $feeRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($feeRPH, true)), __LINE__);
        }
        $this->FeeRPH = $feeRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CodeListFeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
