<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargesType StructType
 * Meta information extracted from the WSDL
 * - documentation: A value representing a supplement for an item over the cost of the item on which a package basic price is calculated; may be repeated for multiple currencies e.g. GBP and Euros.
 * @subpackage Structs
 */
class ChargesType extends AbstractStructBase
{
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - documentation: The charge element repeats to allow differential charging according to, for example, age.
     * - maxOccurs: 9
     * @var mixed[]
     */
    public $Charge;
    /**
     * Constructor method for ChargesType
     * @uses ChargesType::setCharge()
     * @param mixed[] $charge
     */
    public function __construct(array $charge = array())
    {
        $this
            ->setCharge($charge);
    }
    /**
     * Get Charge value
     * @return mixed[]|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * This method is responsible for validating the values passed to the setCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeForArrayConstraintsFromSetCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargesTypeChargeItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($chargesTypeChargeItem) ? get_class($chargesTypeChargeItem) : sprintf('%s(%s)', gettype($chargesTypeChargeItem), var_export($chargesTypeChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Charge property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Charge value
     * @throws \InvalidArgumentException
     * @param mixed[] $charge
     * @return \StructType\ChargesType
     */
    public function setCharge(array $charge = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeArrayErrorMessage = self::validateChargeForArrayConstraintsFromSetCharge($charge))) {
            throw new \InvalidArgumentException($chargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($charge) && count($charge) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($charge)), __LINE__);
        }
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ChargesType
     */
    public function addToCharge($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Charge property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Charge) && count($this->Charge) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Charge)), __LINE__);
        }
        $this->Charge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
