<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeUnit StructType
 * Meta information extracted from the WSDL
 * - documentation: Charge unit information.
 * - type: OTA_CodeType
 * - use: optional
 * @subpackage Structs
 */
class ChargeUnit extends AbstractStructBase
{
    /**
     * The Unit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Unit
     */
    public $Unit;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Frequency
     */
    public $Frequency;
    /**
     * Constructor method for ChargeUnit
     * @uses ChargeUnit::setUnit()
     * @uses ChargeUnit::setFrequency()
     * @param \StructType\Unit $unit
     * @param \StructType\Frequency $frequency
     */
    public function __construct(\StructType\Unit $unit = null, \StructType\Frequency $frequency = null)
    {
        $this
            ->setUnit($unit)
            ->setFrequency($frequency);
    }
    /**
     * Get Unit value
     * @return \StructType\Unit|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param \StructType\Unit $unit
     * @return \StructType\ChargeUnit
     */
    public function setUnit(\StructType\Unit $unit = null)
    {
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Get Frequency value
     * @return \StructType\Frequency|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param \StructType\Frequency $frequency
     * @return \StructType\ChargeUnit
     */
    public function setFrequency(\StructType\Frequency $frequency = null)
    {
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeUnit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
