<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cautions StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of items of essential information relating to components of a package itinerary.
 * @subpackage Structs
 */
class Cautions extends AbstractStructBase
{
    /**
     * The Caution
     * Meta information extracted from the WSDL
     * - documentation: Provides information regarding a package component which could affect a customer's decision to book.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $Caution;
    /**
     * Constructor method for Cautions
     * @uses Cautions::setCaution()
     * @param mixed[] $caution
     */
    public function __construct(array $caution = array())
    {
        $this
            ->setCaution($caution);
    }
    /**
     * Get Caution value
     * @return mixed[]|null
     */
    public function getCaution()
    {
        return $this->Caution;
    }
    /**
     * This method is responsible for validating the values passed to the setCaution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCaution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCautionForArrayConstraintsFromSetCaution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cautionsCautionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cautionsCautionItem) ? get_class($cautionsCautionItem) : sprintf('%s(%s)', gettype($cautionsCautionItem), var_export($cautionsCautionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Caution property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Caution value
     * @throws \InvalidArgumentException
     * @param mixed[] $caution
     * @return \StructType\Cautions
     */
    public function setCaution(array $caution = array())
    {
        // validation for constraint: array
        if ('' !== ($cautionArrayErrorMessage = self::validateCautionForArrayConstraintsFromSetCaution($caution))) {
            throw new \InvalidArgumentException($cautionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($caution) && count($caution) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($caution)), __LINE__);
        }
        $this->Caution = $caution;
        return $this;
    }
    /**
     * Add item to Caution value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Cautions
     */
    public function addToCaution($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Caution property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Caution) && count($this->Caution) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Caution)), __LINE__);
        }
        $this->Caution[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Cautions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
