<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierFee StructType
 * Meta information extracted from the WSDL
 * - documentation: In the Code attribute is the two/three character designator representing the carrier whose fee is represented by the carrier fee code. In the CompanyShortName is the Carrier fee commercial name. | Used to specify if the carrier fee
 * is related to the booking, ticketing, or service and associated information.
 * @subpackage Structs
 */
class CarrierFee extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: The type of carrier fee, i.e., related to booking or ticketing or service. Refer to OpenTravel Code List "EMD Carrier Fee Type."
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The FeeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\FeeAmount[]
     */
    public $FeeAmount;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: A sequential number representing the order of the fare comonents within the fare component calculation.
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * The TariffNumber
     * Meta information extracted from the WSDL
     * - documentation: The tariff number where the fare data is filed.
     * - use: optional
     * @var string
     */
    public $TariffNumber;
    /**
     * The RuleNumber
     * Meta information extracted from the WSDL
     * - documentation: The rule number within the tariff where the fare data is filed.
     * - use: optional
     * @var string
     */
    public $RuleNumber;
    /**
     * The RuleCode
     * Meta information extracted from the WSDL
     * - documentation: System generated data indicating the ticketed fare is from a specific rule filed fare sent by the issuing system.
     * - use: optional
     * @var string
     */
    public $RuleCode;
    /**
     * The FareClassCode
     * Meta information extracted from the WSDL
     * - documentation: The fare class code that must be used when matching alternate cateory data as specifed by the carrier fee fare rule code, carrier fee rule number, and carrier fee tariff number fields.
     * - use: optional
     * @var string
     */
    public $FareClassCode;
    /**
     * The ReportingCode
     * Meta information extracted from the WSDL
     * - documentation: The identifier reflecting the method of pricing for the carrier fee.
     * - use: optional
     * @var string
     */
    public $ReportingCode;
    /**
     * Constructor method for CarrierFee
     * @uses CarrierFee::setType()
     * @uses CarrierFee::setFeeAmount()
     * @uses CarrierFee::setNumber()
     * @uses CarrierFee::setTariffNumber()
     * @uses CarrierFee::setRuleNumber()
     * @uses CarrierFee::setRuleCode()
     * @uses CarrierFee::setFareClassCode()
     * @uses CarrierFee::setReportingCode()
     * @param string $type
     * @param \StructType\FeeAmount[] $feeAmount
     * @param int $number
     * @param string $tariffNumber
     * @param string $ruleNumber
     * @param string $ruleCode
     * @param string $fareClassCode
     * @param string $reportingCode
     */
    public function __construct($type = null, array $feeAmount = array(), $number = null, $tariffNumber = null, $ruleNumber = null, $ruleCode = null, $fareClassCode = null, $reportingCode = null)
    {
        $this
            ->setType($type)
            ->setFeeAmount($feeAmount)
            ->setNumber($number)
            ->setTariffNumber($tariffNumber)
            ->setRuleNumber($ruleNumber)
            ->setRuleCode($ruleCode)
            ->setFareClassCode($fareClassCode)
            ->setReportingCode($reportingCode);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\CarrierFee
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get FeeAmount value
     * @return \StructType\FeeAmount[]|null
     */
    public function getFeeAmount()
    {
        return $this->FeeAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setFeeAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeeAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeAmountForArrayConstraintsFromSetFeeAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $carrierFeeFeeAmountItem) {
            // validation for constraint: itemType
            if (!$carrierFeeFeeAmountItem instanceof \StructType\FeeAmount) {
                $invalidValues[] = is_object($carrierFeeFeeAmountItem) ? get_class($carrierFeeFeeAmountItem) : sprintf('%s(%s)', gettype($carrierFeeFeeAmountItem), var_export($carrierFeeFeeAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FeeAmount property can only contain items of type \StructType\FeeAmount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FeeAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeAmount[] $feeAmount
     * @return \StructType\CarrierFee
     */
    public function setFeeAmount(array $feeAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($feeAmountArrayErrorMessage = self::validateFeeAmountForArrayConstraintsFromSetFeeAmount($feeAmount))) {
            throw new \InvalidArgumentException($feeAmountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($feeAmount) && count($feeAmount) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($feeAmount)), __LINE__);
        }
        $this->FeeAmount = $feeAmount;
        return $this;
    }
    /**
     * Add item to FeeAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeAmount $item
     * @return \StructType\CarrierFee
     */
    public function addToFeeAmount(\StructType\FeeAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeeAmount) {
            throw new \InvalidArgumentException(sprintf('The FeeAmount property can only contain items of type \StructType\FeeAmount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->FeeAmount) && count($this->FeeAmount) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->FeeAmount)), __LINE__);
        }
        $this->FeeAmount[] = $item;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\CarrierFee
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get TariffNumber value
     * @return string|null
     */
    public function getTariffNumber()
    {
        return $this->TariffNumber;
    }
    /**
     * Set TariffNumber value
     * @param string $tariffNumber
     * @return \StructType\CarrierFee
     */
    public function setTariffNumber($tariffNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tariffNumber) && !is_string($tariffNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffNumber, true), gettype($tariffNumber)), __LINE__);
        }
        $this->TariffNumber = $tariffNumber;
        return $this;
    }
    /**
     * Get RuleNumber value
     * @return string|null
     */
    public function getRuleNumber()
    {
        return $this->RuleNumber;
    }
    /**
     * Set RuleNumber value
     * @param string $ruleNumber
     * @return \StructType\CarrierFee
     */
    public function setRuleNumber($ruleNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ruleNumber) && !is_string($ruleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleNumber, true), gettype($ruleNumber)), __LINE__);
        }
        $this->RuleNumber = $ruleNumber;
        return $this;
    }
    /**
     * Get RuleCode value
     * @return string|null
     */
    public function getRuleCode()
    {
        return $this->RuleCode;
    }
    /**
     * Set RuleCode value
     * @param string $ruleCode
     * @return \StructType\CarrierFee
     */
    public function setRuleCode($ruleCode = null)
    {
        // validation for constraint: string
        if (!is_null($ruleCode) && !is_string($ruleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleCode, true), gettype($ruleCode)), __LINE__);
        }
        $this->RuleCode = $ruleCode;
        return $this;
    }
    /**
     * Get FareClassCode value
     * @return string|null
     */
    public function getFareClassCode()
    {
        return $this->FareClassCode;
    }
    /**
     * Set FareClassCode value
     * @param string $fareClassCode
     * @return \StructType\CarrierFee
     */
    public function setFareClassCode($fareClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareClassCode) && !is_string($fareClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClassCode, true), gettype($fareClassCode)), __LINE__);
        }
        $this->FareClassCode = $fareClassCode;
        return $this;
    }
    /**
     * Get ReportingCode value
     * @return string|null
     */
    public function getReportingCode()
    {
        return $this->ReportingCode;
    }
    /**
     * Set ReportingCode value
     * @param string $reportingCode
     * @return \StructType\CarrierFee
     */
    public function setReportingCode($reportingCode = null)
    {
        // validation for constraint: string
        if (!is_null($reportingCode) && !is_string($reportingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportingCode, true), gettype($reportingCode)), __LINE__);
        }
        $this->ReportingCode = $reportingCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CarrierFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
