<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarbonFootprint StructType
 * Meta information extracted from the WSDL
 * - documentation: Carbon foot print information.
 * @subpackage Structs
 */
class CarbonFootprint extends AbstractStructBase
{
    /**
     * The CarbonUOM
     * Meta information extracted from the WSDL
     * - documentation: Example: Gallon(s) | Carbon unit of measure.
     * - minOccurs: 0
     * @var mixed
     */
    public $CarbonUOM;
    /**
     * The NonCarbonMeasureInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property measures the impact of its non-carbon emitting environmental measures. | Example: true | Non-carbon impact measured indicator.
     * - use: optional
     * @var bool
     */
    public $NonCarbonMeasureInd;
    /**
     * The NonCarbonMeasureDesc
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This describes how the property assesses the impact of its non-carbon emitting environmental measures. | Non-carbon measurement method.
     * - use: optional
     * @var string
     */
    public $NonCarbonMeasureDesc;
    /**
     * The MeetingEvent
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This is the carbon factor of a meeting or event expressed in pounds of carbon dioxide. | Example: 633 | Meeting/ event carbon dioxide pound(s).
     * - use: optional
     * @var int
     */
    public $MeetingEvent;
    /**
     * The RoomNight
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This is the carbon factor of a room per night expressed in pounds of carbon dioxide. | Example: 33 | Room night carbon dioxide pound(s).
     * - use: optional
     * @var int
     */
    public $RoomNight;
    /**
     * The WeatherNormalized
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This is the weather-normalized carbon footprint expressed in pounds of carbon dioxide. | Example: 525 | Weather-normalized carbon dioxide pound(s).
     * - use: optional
     * @var int
     */
    public $WeatherNormalized;
    /**
     * Constructor method for CarbonFootprint
     * @uses CarbonFootprint::setCarbonUOM()
     * @uses CarbonFootprint::setNonCarbonMeasureInd()
     * @uses CarbonFootprint::setNonCarbonMeasureDesc()
     * @uses CarbonFootprint::setMeetingEvent()
     * @uses CarbonFootprint::setRoomNight()
     * @uses CarbonFootprint::setWeatherNormalized()
     * @param mixed $carbonUOM
     * @param bool $nonCarbonMeasureInd
     * @param string $nonCarbonMeasureDesc
     * @param int $meetingEvent
     * @param int $roomNight
     * @param int $weatherNormalized
     */
    public function __construct($carbonUOM = null, $nonCarbonMeasureInd = null, $nonCarbonMeasureDesc = null, $meetingEvent = null, $roomNight = null, $weatherNormalized = null)
    {
        $this
            ->setCarbonUOM($carbonUOM)
            ->setNonCarbonMeasureInd($nonCarbonMeasureInd)
            ->setNonCarbonMeasureDesc($nonCarbonMeasureDesc)
            ->setMeetingEvent($meetingEvent)
            ->setRoomNight($roomNight)
            ->setWeatherNormalized($weatherNormalized);
    }
    /**
     * Get CarbonUOM value
     * @return mixed|null
     */
    public function getCarbonUOM()
    {
        return $this->CarbonUOM;
    }
    /**
     * Set CarbonUOM value
     * @param mixed $carbonUOM
     * @return \StructType\CarbonFootprint
     */
    public function setCarbonUOM($carbonUOM = null)
    {
        $this->CarbonUOM = $carbonUOM;
        return $this;
    }
    /**
     * Get NonCarbonMeasureInd value
     * @return bool|null
     */
    public function getNonCarbonMeasureInd()
    {
        return $this->NonCarbonMeasureInd;
    }
    /**
     * Set NonCarbonMeasureInd value
     * @param bool $nonCarbonMeasureInd
     * @return \StructType\CarbonFootprint
     */
    public function setNonCarbonMeasureInd($nonCarbonMeasureInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonCarbonMeasureInd) && !is_bool($nonCarbonMeasureInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonCarbonMeasureInd, true), gettype($nonCarbonMeasureInd)), __LINE__);
        }
        $this->NonCarbonMeasureInd = $nonCarbonMeasureInd;
        return $this;
    }
    /**
     * Get NonCarbonMeasureDesc value
     * @return string|null
     */
    public function getNonCarbonMeasureDesc()
    {
        return $this->NonCarbonMeasureDesc;
    }
    /**
     * Set NonCarbonMeasureDesc value
     * @param string $nonCarbonMeasureDesc
     * @return \StructType\CarbonFootprint
     */
    public function setNonCarbonMeasureDesc($nonCarbonMeasureDesc = null)
    {
        // validation for constraint: string
        if (!is_null($nonCarbonMeasureDesc) && !is_string($nonCarbonMeasureDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonCarbonMeasureDesc, true), gettype($nonCarbonMeasureDesc)), __LINE__);
        }
        $this->NonCarbonMeasureDesc = $nonCarbonMeasureDesc;
        return $this;
    }
    /**
     * Get MeetingEvent value
     * @return int|null
     */
    public function getMeetingEvent()
    {
        return $this->MeetingEvent;
    }
    /**
     * Set MeetingEvent value
     * @param int $meetingEvent
     * @return \StructType\CarbonFootprint
     */
    public function setMeetingEvent($meetingEvent = null)
    {
        // validation for constraint: int
        if (!is_null($meetingEvent) && !(is_int($meetingEvent) || ctype_digit($meetingEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($meetingEvent, true), gettype($meetingEvent)), __LINE__);
        }
        $this->MeetingEvent = $meetingEvent;
        return $this;
    }
    /**
     * Get RoomNight value
     * @return int|null
     */
    public function getRoomNight()
    {
        return $this->RoomNight;
    }
    /**
     * Set RoomNight value
     * @param int $roomNight
     * @return \StructType\CarbonFootprint
     */
    public function setRoomNight($roomNight = null)
    {
        // validation for constraint: int
        if (!is_null($roomNight) && !(is_int($roomNight) || ctype_digit($roomNight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomNight, true), gettype($roomNight)), __LINE__);
        }
        $this->RoomNight = $roomNight;
        return $this;
    }
    /**
     * Get WeatherNormalized value
     * @return int|null
     */
    public function getWeatherNormalized()
    {
        return $this->WeatherNormalized;
    }
    /**
     * Set WeatherNormalized value
     * @param int $weatherNormalized
     * @return \StructType\CarbonFootprint
     */
    public function setWeatherNormalized($weatherNormalized = null)
    {
        // validation for constraint: int
        if (!is_null($weatherNormalized) && !(is_int($weatherNormalized) || ctype_digit($weatherNormalized))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weatherNormalized, true), gettype($weatherNormalized)), __LINE__);
        }
        $this->WeatherNormalized = $weatherNormalized;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CarbonFootprint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
