<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPenaltyType StructType
 * Meta information extracted from the WSDL
 * - documentation: The date time span for which the policy applies. | If a day(s) of the week is set to true then the associated policy applies to that day of week. | The CancelPenalty class defines the cancellation policy of the hotel facility.
 * @subpackage Structs
 */
class CancelPenaltyType extends AbstractStructBase
{
    /**
     * The Deadline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Deadline
     */
    public $Deadline;
    /**
     * The AmountPercent
     * Meta information extracted from the WSDL
     * - documentation: Cancellation fee expressed as a fixed amount, or percentage of/or room nights.
     * - minOccurs: 0
     * @var mixed
     */
    public $AmountPercent;
    /**
     * The PenaltyDescription
     * Meta information extracted from the WSDL
     * - documentation: Text description of the Penalty in a given language.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PenaltyDescription;
    /**
     * The ConfirmClassCode
     * Meta information extracted from the WSDL
     * - documentation: Confirm Class.
     * - use: optional
     * @var string
     */
    public $ConfirmClassCode;
    /**
     * The PolicyCode
     * Meta information extracted from the WSDL
     * - documentation: Policy Class.
     * - use: optional
     * @var string
     */
    public $PolicyCode;
    /**
     * The NonRefundable
     * Meta information extracted from the WSDL
     * - documentation: Indicates that any prepayment for the reservation is non refundable, therefore a 100% penalty on the prepayment is applied, irrespective of deadline.
     * - use: optional
     * @var bool
     */
    public $NonRefundable;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A system specific room type to which this cancellation penalty applies.
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The NoCancelInd
     * Meta information extracted from the WSDL
     * - documentation: Note: This will typically be set to false indicating that a reservation may be cancelled. | Example: false | If true, the reservation may not be cancelled once the cancellation deadline has expired.
     * @var bool
     */
    public $NoCancelInd;
    /**
     * Constructor method for CancelPenaltyType
     * @uses CancelPenaltyType::setDeadline()
     * @uses CancelPenaltyType::setAmountPercent()
     * @uses CancelPenaltyType::setPenaltyDescription()
     * @uses CancelPenaltyType::setConfirmClassCode()
     * @uses CancelPenaltyType::setPolicyCode()
     * @uses CancelPenaltyType::setNonRefundable()
     * @uses CancelPenaltyType::setRoomTypeCode()
     * @uses CancelPenaltyType::setNoCancelInd()
     * @param \StructType\Deadline $deadline
     * @param mixed $amountPercent
     * @param mixed[] $penaltyDescription
     * @param string $confirmClassCode
     * @param string $policyCode
     * @param bool $nonRefundable
     * @param string $roomTypeCode
     * @param bool $noCancelInd
     */
    public function __construct(\StructType\Deadline $deadline = null, $amountPercent = null, array $penaltyDescription = array(), $confirmClassCode = null, $policyCode = null, $nonRefundable = null, $roomTypeCode = null, $noCancelInd = null)
    {
        $this
            ->setDeadline($deadline)
            ->setAmountPercent($amountPercent)
            ->setPenaltyDescription($penaltyDescription)
            ->setConfirmClassCode($confirmClassCode)
            ->setPolicyCode($policyCode)
            ->setNonRefundable($nonRefundable)
            ->setRoomTypeCode($roomTypeCode)
            ->setNoCancelInd($noCancelInd);
    }
    /**
     * Get Deadline value
     * @return \StructType\Deadline|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * Set Deadline value
     * @param \StructType\Deadline $deadline
     * @return \StructType\CancelPenaltyType
     */
    public function setDeadline(\StructType\Deadline $deadline = null)
    {
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Get AmountPercent value
     * @return mixed|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param mixed $amountPercent
     * @return \StructType\CancelPenaltyType
     */
    public function setAmountPercent($amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get PenaltyDescription value
     * @return mixed[]|null
     */
    public function getPenaltyDescription()
    {
        return $this->PenaltyDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyDescriptionForArrayConstraintsFromSetPenaltyDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelPenaltyTypePenaltyDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cancelPenaltyTypePenaltyDescriptionItem) ? get_class($cancelPenaltyTypePenaltyDescriptionItem) : sprintf('%s(%s)', gettype($cancelPenaltyTypePenaltyDescriptionItem), var_export($cancelPenaltyTypePenaltyDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $penaltyDescription
     * @return \StructType\CancelPenaltyType
     */
    public function setPenaltyDescription(array $penaltyDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyDescriptionArrayErrorMessage = self::validatePenaltyDescriptionForArrayConstraintsFromSetPenaltyDescription($penaltyDescription))) {
            throw new \InvalidArgumentException($penaltyDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($penaltyDescription) && count($penaltyDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($penaltyDescription)), __LINE__);
        }
        $this->PenaltyDescription = $penaltyDescription;
        return $this;
    }
    /**
     * Add item to PenaltyDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CancelPenaltyType
     */
    public function addToPenaltyDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PenaltyDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->PenaltyDescription) && count($this->PenaltyDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->PenaltyDescription)), __LINE__);
        }
        $this->PenaltyDescription[] = $item;
        return $this;
    }
    /**
     * Get ConfirmClassCode value
     * @return string|null
     */
    public function getConfirmClassCode()
    {
        return $this->ConfirmClassCode;
    }
    /**
     * Set ConfirmClassCode value
     * @param string $confirmClassCode
     * @return \StructType\CancelPenaltyType
     */
    public function setConfirmClassCode($confirmClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($confirmClassCode) && !is_string($confirmClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmClassCode, true), gettype($confirmClassCode)), __LINE__);
        }
        $this->ConfirmClassCode = $confirmClassCode;
        return $this;
    }
    /**
     * Get PolicyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->PolicyCode;
    }
    /**
     * Set PolicyCode value
     * @param string $policyCode
     * @return \StructType\CancelPenaltyType
     */
    public function setPolicyCode($policyCode = null)
    {
        // validation for constraint: string
        if (!is_null($policyCode) && !is_string($policyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyCode, true), gettype($policyCode)), __LINE__);
        }
        $this->PolicyCode = $policyCode;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool|null
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \StructType\CancelPenaltyType
     */
    public function setNonRefundable($nonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundable) && !is_bool($nonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundable, true), gettype($nonRefundable)), __LINE__);
        }
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\CancelPenaltyType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get NoCancelInd value
     * @return bool|null
     */
    public function getNoCancelInd()
    {
        return $this->NoCancelInd;
    }
    /**
     * Set NoCancelInd value
     * @param bool $noCancelInd
     * @return \StructType\CancelPenaltyType
     */
    public function setNoCancelInd($noCancelInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($noCancelInd) && !is_bool($noCancelInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noCancelInd, true), gettype($noCancelInd)), __LINE__);
        }
        $this->NoCancelInd = $noCancelInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelPenaltyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
