<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPenaltyInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Information regarding the cancellation or modification policy for this vehicle type.
 * @subpackage Structs
 */
class CancelPenaltyInfo extends AbstractStructBase
{
    /**
     * The Deadline
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\Deadline[]
     */
    public $Deadline;
    /**
     * The PenaltyFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PenaltyFee
     */
    public $PenaltyFee;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Provides additional information about the cancel penalty.
     * - minOccurs: 0
     * @var mixed
     */
    public $Description;
    /**
     * The GuaranteeRequiredInd
     * Meta information extracted from the WSDL
     * - documentation: When true, a guarantee is required.
     * - use: optional
     * @var bool
     */
    public $GuaranteeRequiredInd;
    /**
     * The ModifyPenaltyInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this indicates the penalty information is for a modification rather than a cancellation.
     * - use: optional
     * @var bool
     */
    public $ModifyPenaltyInd;
    /**
     * Constructor method for CancelPenaltyInfo
     * @uses CancelPenaltyInfo::setDeadline()
     * @uses CancelPenaltyInfo::setPenaltyFee()
     * @uses CancelPenaltyInfo::setDescription()
     * @uses CancelPenaltyInfo::setGuaranteeRequiredInd()
     * @uses CancelPenaltyInfo::setModifyPenaltyInd()
     * @param \StructType\Deadline[] $deadline
     * @param \StructType\PenaltyFee $penaltyFee
     * @param mixed $description
     * @param bool $guaranteeRequiredInd
     * @param bool $modifyPenaltyInd
     */
    public function __construct(array $deadline = array(), \StructType\PenaltyFee $penaltyFee = null, $description = null, $guaranteeRequiredInd = null, $modifyPenaltyInd = null)
    {
        $this
            ->setDeadline($deadline)
            ->setPenaltyFee($penaltyFee)
            ->setDescription($description)
            ->setGuaranteeRequiredInd($guaranteeRequiredInd)
            ->setModifyPenaltyInd($modifyPenaltyInd);
    }
    /**
     * Get Deadline value
     * @return \StructType\Deadline[]|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * This method is responsible for validating the values passed to the setDeadline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeadline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeadlineForArrayConstraintsFromSetDeadline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelPenaltyInfoDeadlineItem) {
            // validation for constraint: itemType
            if (!$cancelPenaltyInfoDeadlineItem instanceof \StructType\Deadline) {
                $invalidValues[] = is_object($cancelPenaltyInfoDeadlineItem) ? get_class($cancelPenaltyInfoDeadlineItem) : sprintf('%s(%s)', gettype($cancelPenaltyInfoDeadlineItem), var_export($cancelPenaltyInfoDeadlineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deadline property can only contain items of type \StructType\Deadline, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deadline value
     * @throws \InvalidArgumentException
     * @param \StructType\Deadline[] $deadline
     * @return \StructType\CancelPenaltyInfo
     */
    public function setDeadline(array $deadline = array())
    {
        // validation for constraint: array
        if ('' !== ($deadlineArrayErrorMessage = self::validateDeadlineForArrayConstraintsFromSetDeadline($deadline))) {
            throw new \InvalidArgumentException($deadlineArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($deadline) && count($deadline) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($deadline)), __LINE__);
        }
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Add item to Deadline value
     * @throws \InvalidArgumentException
     * @param \StructType\Deadline $item
     * @return \StructType\CancelPenaltyInfo
     */
    public function addToDeadline(\StructType\Deadline $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Deadline) {
            throw new \InvalidArgumentException(sprintf('The Deadline property can only contain items of type \StructType\Deadline, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Deadline) && count($this->Deadline) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Deadline)), __LINE__);
        }
        $this->Deadline[] = $item;
        return $this;
    }
    /**
     * Get PenaltyFee value
     * @return \StructType\PenaltyFee|null
     */
    public function getPenaltyFee()
    {
        return $this->PenaltyFee;
    }
    /**
     * Set PenaltyFee value
     * @param \StructType\PenaltyFee $penaltyFee
     * @return \StructType\CancelPenaltyInfo
     */
    public function setPenaltyFee(\StructType\PenaltyFee $penaltyFee = null)
    {
        $this->PenaltyFee = $penaltyFee;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param mixed $description
     * @return \StructType\CancelPenaltyInfo
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get GuaranteeRequiredInd value
     * @return bool|null
     */
    public function getGuaranteeRequiredInd()
    {
        return $this->GuaranteeRequiredInd;
    }
    /**
     * Set GuaranteeRequiredInd value
     * @param bool $guaranteeRequiredInd
     * @return \StructType\CancelPenaltyInfo
     */
    public function setGuaranteeRequiredInd($guaranteeRequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteeRequiredInd) && !is_bool($guaranteeRequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteeRequiredInd, true), gettype($guaranteeRequiredInd)), __LINE__);
        }
        $this->GuaranteeRequiredInd = $guaranteeRequiredInd;
        return $this;
    }
    /**
     * Get ModifyPenaltyInd value
     * @return bool|null
     */
    public function getModifyPenaltyInd()
    {
        return $this->ModifyPenaltyInd;
    }
    /**
     * Set ModifyPenaltyInd value
     * @param bool $modifyPenaltyInd
     * @return \StructType\CancelPenaltyInfo
     */
    public function setModifyPenaltyInd($modifyPenaltyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($modifyPenaltyInd) && !is_bool($modifyPenaltyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modifyPenaltyInd, true), gettype($modifyPenaltyInd)), __LINE__);
        }
        $this->ModifyPenaltyInd = $modifyPenaltyInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelPenaltyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
