<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Cabin information for the aircraft equipment type, including seat types, cabin class code and cabin sub-class information.
 * @subpackage Structs
 */
class CabinInfo extends AbstractStructBase
{
    /**
     * The SubType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubType[]
     */
    public $SubType;
    /**
     * The ReqSeatQty
     * Meta information extracted from the WSDL
     * - documentation: The quantity of requested seats for this cabin type.
     * - use: optional
     * @var int
     */
    public $ReqSeatQty;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Reservation booking designator for the fare.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The ClassCode
     * Meta information extracted from the WSDL
     * - documentation: The cabin class. Use a value from the enumerated list or enter a string value that is known to your trading partners.
     * - use: optional
     * @var string
     */
    public $ClassCode;
    /**
     * The SeatType
     * Meta information extracted from the WSDL
     * - documentation: A seat preference type. Use a value from the OpenTravel Seat Type Preference (STP) code list or enter a string value that is known to your trading partners.
     * - use: optional
     * @var string
     */
    public $SeatType;
    /**
     * The TravelerRPH
     * Meta information extracted from the WSDL
     * - documentation: A reference to a unique traveler ID (defined elsewhere in this message) that associates the traveler to this cabin class and seat information.
     * - use: optional
     * @var string
     */
    public $TravelerRPH;
    /**
     * The OrigDestSequenceRPH
     * Meta information extracted from the WSDL
     * - documentation: A reference to a unique O/D pair ID (defined elsewhere in this message) that associates the O/D portion of a trip to this cabin class and seat information.
     * - use: optional
     * @var string
     */
    public $OrigDestSequenceRPH;
    /**
     * The ItinerarySegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: A reference to a unique O/D flight segment ID (defined elsewhere in this message) that associates the O/D flight segment to this cabin class and seat inforamtion.
     * - use: optional
     * @var string
     */
    public $ItinerarySegmentRPH;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for this cabin and seat information that may be referenced elsewhere in this message.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for CabinInfo
     * @uses CabinInfo::setSubType()
     * @uses CabinInfo::setReqSeatQty()
     * @uses CabinInfo::setResBookDesigCode()
     * @uses CabinInfo::setClassCode()
     * @uses CabinInfo::setSeatType()
     * @uses CabinInfo::setTravelerRPH()
     * @uses CabinInfo::setOrigDestSequenceRPH()
     * @uses CabinInfo::setItinerarySegmentRPH()
     * @uses CabinInfo::setRPH()
     * @param \StructType\SubType[] $subType
     * @param int $reqSeatQty
     * @param string $resBookDesigCode
     * @param string $classCode
     * @param string $seatType
     * @param string $travelerRPH
     * @param string $origDestSequenceRPH
     * @param string $itinerarySegmentRPH
     * @param string $rPH
     */
    public function __construct(array $subType = array(), $reqSeatQty = null, $resBookDesigCode = null, $classCode = null, $seatType = null, $travelerRPH = null, $origDestSequenceRPH = null, $itinerarySegmentRPH = null, $rPH = null)
    {
        $this
            ->setSubType($subType)
            ->setReqSeatQty($reqSeatQty)
            ->setResBookDesigCode($resBookDesigCode)
            ->setClassCode($classCode)
            ->setSeatType($seatType)
            ->setTravelerRPH($travelerRPH)
            ->setOrigDestSequenceRPH($origDestSequenceRPH)
            ->setItinerarySegmentRPH($itinerarySegmentRPH)
            ->setRPH($rPH);
    }
    /**
     * Get SubType value
     * @return \StructType\SubType[]|null
     */
    public function getSubType()
    {
        return $this->SubType;
    }
    /**
     * This method is responsible for validating the values passed to the setSubType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubTypeForArrayConstraintsFromSetSubType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinInfoSubTypeItem) {
            // validation for constraint: itemType
            if (!$cabinInfoSubTypeItem instanceof \StructType\SubType) {
                $invalidValues[] = is_object($cabinInfoSubTypeItem) ? get_class($cabinInfoSubTypeItem) : sprintf('%s(%s)', gettype($cabinInfoSubTypeItem), var_export($cabinInfoSubTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubType property can only contain items of type \StructType\SubType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubType value
     * @throws \InvalidArgumentException
     * @param \StructType\SubType[] $subType
     * @return \StructType\CabinInfo
     */
    public function setSubType(array $subType = array())
    {
        // validation for constraint: array
        if ('' !== ($subTypeArrayErrorMessage = self::validateSubTypeForArrayConstraintsFromSetSubType($subType))) {
            throw new \InvalidArgumentException($subTypeArrayErrorMessage, __LINE__);
        }
        $this->SubType = $subType;
        return $this;
    }
    /**
     * Add item to SubType value
     * @throws \InvalidArgumentException
     * @param \StructType\SubType $item
     * @return \StructType\CabinInfo
     */
    public function addToSubType(\StructType\SubType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubType) {
            throw new \InvalidArgumentException(sprintf('The SubType property can only contain items of type \StructType\SubType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubType[] = $item;
        return $this;
    }
    /**
     * Get ReqSeatQty value
     * @return int|null
     */
    public function getReqSeatQty()
    {
        return $this->ReqSeatQty;
    }
    /**
     * Set ReqSeatQty value
     * @param int $reqSeatQty
     * @return \StructType\CabinInfo
     */
    public function setReqSeatQty($reqSeatQty = null)
    {
        // validation for constraint: int
        if (!is_null($reqSeatQty) && !(is_int($reqSeatQty) || ctype_digit($reqSeatQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reqSeatQty, true), gettype($reqSeatQty)), __LINE__);
        }
        $this->ReqSeatQty = $reqSeatQty;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\CabinInfo
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get ClassCode value
     * @return string|null
     */
    public function getClassCode()
    {
        return $this->ClassCode;
    }
    /**
     * Set ClassCode value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $classCode
     * @return \StructType\CabinInfo
     */
    public function setClassCode($classCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($classCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($classCode) ? implode(', ', $classCode) : var_export($classCode, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->ClassCode = $classCode;
        return $this;
    }
    /**
     * Get SeatType value
     * @return string|null
     */
    public function getSeatType()
    {
        return $this->SeatType;
    }
    /**
     * Set SeatType value
     * @param string $seatType
     * @return \StructType\CabinInfo
     */
    public function setSeatType($seatType = null)
    {
        // validation for constraint: string
        if (!is_null($seatType) && !is_string($seatType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatType, true), gettype($seatType)), __LINE__);
        }
        $this->SeatType = $seatType;
        return $this;
    }
    /**
     * Get TravelerRPH value
     * @return string|null
     */
    public function getTravelerRPH()
    {
        return $this->TravelerRPH;
    }
    /**
     * Set TravelerRPH value
     * @param string $travelerRPH
     * @return \StructType\CabinInfo
     */
    public function setTravelerRPH($travelerRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRPH) && !is_string($travelerRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerRPH, true), gettype($travelerRPH)), __LINE__);
        }
        $this->TravelerRPH = $travelerRPH;
        return $this;
    }
    /**
     * Get OrigDestSequenceRPH value
     * @return string|null
     */
    public function getOrigDestSequenceRPH()
    {
        return $this->OrigDestSequenceRPH;
    }
    /**
     * Set OrigDestSequenceRPH value
     * @param string $origDestSequenceRPH
     * @return \StructType\CabinInfo
     */
    public function setOrigDestSequenceRPH($origDestSequenceRPH = null)
    {
        // validation for constraint: string
        if (!is_null($origDestSequenceRPH) && !is_string($origDestSequenceRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origDestSequenceRPH, true), gettype($origDestSequenceRPH)), __LINE__);
        }
        $this->OrigDestSequenceRPH = $origDestSequenceRPH;
        return $this;
    }
    /**
     * Get ItinerarySegmentRPH value
     * @return string|null
     */
    public function getItinerarySegmentRPH()
    {
        return $this->ItinerarySegmentRPH;
    }
    /**
     * Set ItinerarySegmentRPH value
     * @param string $itinerarySegmentRPH
     * @return \StructType\CabinInfo
     */
    public function setItinerarySegmentRPH($itinerarySegmentRPH = null)
    {
        // validation for constraint: string
        if (!is_null($itinerarySegmentRPH) && !is_string($itinerarySegmentRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itinerarySegmentRPH, true), gettype($itinerarySegmentRPH)), __LINE__);
        }
        $this->ItinerarySegmentRPH = $itinerarySegmentRPH;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\CabinInfo
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
