<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinClassDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Detail information about a cabin class, including row characteristics, zone and seat details.
 * - mixed: true
 * @subpackage Structs
 */
class CabinClassDetailType extends AbstractStructBase
{
    /**
     * The AvailabilityList
     * Meta information extracted from the WSDL
     * - documentation: A quick list of each seat in a cabin and its availability. Note, accompanying seat details are in the Summary and Detail elements.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AvailabilityList;
    /**
     * The RowInfo
     * Meta information extracted from the WSDL
     * - documentation: Cabin row information.
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RowInfo;
    /**
     * The SeatInfo
     * Meta information extracted from the WSDL
     * - documentation: Summary and detailed seat information.
     * - minOccurs: 0
     * @var mixed
     */
    public $SeatInfo;
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - documentation: Zones associated with the cabin class.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Zone;
    /**
     * The Layout
     * Meta information extracted from the WSDL
     * - documentation: The cabin layout.
     * - use: optional
     * @var string
     */
    public $Layout;
    /**
     * The UpperDeckInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this cabin is located on an upper deck.
     * - use: optional
     * @var bool
     */
    public $UpperDeckInd;
    /**
     * The ColumnNumber
     * Meta information extracted from the WSDL
     * - documentation: The column number associated with the row.
     * - use: optional
     * @var int
     */
    public $ColumnNumber;
    /**
     * The ColumnSpan
     * Meta information extracted from the WSDL
     * - documentation: The number of columns the row spans.
     * - use: optional
     * @var int
     */
    public $ColumnSpan;
    /**
     * Constructor method for CabinClassDetailType
     * @uses CabinClassDetailType::setAvailabilityList()
     * @uses CabinClassDetailType::setRowInfo()
     * @uses CabinClassDetailType::setSeatInfo()
     * @uses CabinClassDetailType::setZone()
     * @uses CabinClassDetailType::setLayout()
     * @uses CabinClassDetailType::setUpperDeckInd()
     * @uses CabinClassDetailType::setColumnNumber()
     * @uses CabinClassDetailType::setColumnSpan()
     * @param mixed[] $availabilityList
     * @param mixed[] $rowInfo
     * @param mixed $seatInfo
     * @param mixed[] $zone
     * @param string $layout
     * @param bool $upperDeckInd
     * @param int $columnNumber
     * @param int $columnSpan
     */
    public function __construct(array $availabilityList = array(), array $rowInfo = array(), $seatInfo = null, array $zone = array(), $layout = null, $upperDeckInd = null, $columnNumber = null, $columnSpan = null)
    {
        $this
            ->setAvailabilityList($availabilityList)
            ->setRowInfo($rowInfo)
            ->setSeatInfo($seatInfo)
            ->setZone($zone)
            ->setLayout($layout)
            ->setUpperDeckInd($upperDeckInd)
            ->setColumnNumber($columnNumber)
            ->setColumnSpan($columnSpan);
    }
    /**
     * Get AvailabilityList value
     * @return mixed[]|null
     */
    public function getAvailabilityList()
    {
        return $this->AvailabilityList;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailabilityList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailabilityList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailabilityListForArrayConstraintsFromSetAvailabilityList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinClassDetailTypeAvailabilityListItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cabinClassDetailTypeAvailabilityListItem) ? get_class($cabinClassDetailTypeAvailabilityListItem) : sprintf('%s(%s)', gettype($cabinClassDetailTypeAvailabilityListItem), var_export($cabinClassDetailTypeAvailabilityListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AvailabilityList property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AvailabilityList value
     * @throws \InvalidArgumentException
     * @param mixed[] $availabilityList
     * @return \StructType\CabinClassDetailType
     */
    public function setAvailabilityList(array $availabilityList = array())
    {
        // validation for constraint: array
        if ('' !== ($availabilityListArrayErrorMessage = self::validateAvailabilityListForArrayConstraintsFromSetAvailabilityList($availabilityList))) {
            throw new \InvalidArgumentException($availabilityListArrayErrorMessage, __LINE__);
        }
        $this->AvailabilityList = $availabilityList;
        return $this;
    }
    /**
     * Add item to AvailabilityList value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CabinClassDetailType
     */
    public function addToAvailabilityList($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AvailabilityList property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AvailabilityList[] = $item;
        return $this;
    }
    /**
     * Get RowInfo value
     * @return mixed[]|null
     */
    public function getRowInfo()
    {
        return $this->RowInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setRowInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRowInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRowInfoForArrayConstraintsFromSetRowInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinClassDetailTypeRowInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cabinClassDetailTypeRowInfoItem) ? get_class($cabinClassDetailTypeRowInfoItem) : sprintf('%s(%s)', gettype($cabinClassDetailTypeRowInfoItem), var_export($cabinClassDetailTypeRowInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RowInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RowInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $rowInfo
     * @return \StructType\CabinClassDetailType
     */
    public function setRowInfo(array $rowInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($rowInfoArrayErrorMessage = self::validateRowInfoForArrayConstraintsFromSetRowInfo($rowInfo))) {
            throw new \InvalidArgumentException($rowInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($rowInfo) && count($rowInfo) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($rowInfo)), __LINE__);
        }
        $this->RowInfo = $rowInfo;
        return $this;
    }
    /**
     * Add item to RowInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CabinClassDetailType
     */
    public function addToRowInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RowInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->RowInfo) && count($this->RowInfo) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->RowInfo)), __LINE__);
        }
        $this->RowInfo[] = $item;
        return $this;
    }
    /**
     * Get SeatInfo value
     * @return mixed|null
     */
    public function getSeatInfo()
    {
        return $this->SeatInfo;
    }
    /**
     * Set SeatInfo value
     * @param mixed $seatInfo
     * @return \StructType\CabinClassDetailType
     */
    public function setSeatInfo($seatInfo = null)
    {
        $this->SeatInfo = $seatInfo;
        return $this;
    }
    /**
     * Get Zone value
     * @return mixed[]|null
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * This method is responsible for validating the values passed to the setZone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZoneForArrayConstraintsFromSetZone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinClassDetailTypeZoneItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cabinClassDetailTypeZoneItem) ? get_class($cabinClassDetailTypeZoneItem) : sprintf('%s(%s)', gettype($cabinClassDetailTypeZoneItem), var_export($cabinClassDetailTypeZoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Zone property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Zone value
     * @throws \InvalidArgumentException
     * @param mixed[] $zone
     * @return \StructType\CabinClassDetailType
     */
    public function setZone(array $zone = array())
    {
        // validation for constraint: array
        if ('' !== ($zoneArrayErrorMessage = self::validateZoneForArrayConstraintsFromSetZone($zone))) {
            throw new \InvalidArgumentException($zoneArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($zone) && count($zone) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Add item to Zone value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CabinClassDetailType
     */
    public function addToZone($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Zone property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Zone) && count($this->Zone) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Zone)), __LINE__);
        }
        $this->Zone[] = $item;
        return $this;
    }
    /**
     * Get Layout value
     * @return string|null
     */
    public function getLayout()
    {
        return $this->Layout;
    }
    /**
     * Set Layout value
     * @param string $layout
     * @return \StructType\CabinClassDetailType
     */
    public function setLayout($layout = null)
    {
        // validation for constraint: string
        if (!is_null($layout) && !is_string($layout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($layout, true), gettype($layout)), __LINE__);
        }
        $this->Layout = $layout;
        return $this;
    }
    /**
     * Get UpperDeckInd value
     * @return bool|null
     */
    public function getUpperDeckInd()
    {
        return $this->UpperDeckInd;
    }
    /**
     * Set UpperDeckInd value
     * @param bool $upperDeckInd
     * @return \StructType\CabinClassDetailType
     */
    public function setUpperDeckInd($upperDeckInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($upperDeckInd) && !is_bool($upperDeckInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upperDeckInd, true), gettype($upperDeckInd)), __LINE__);
        }
        $this->UpperDeckInd = $upperDeckInd;
        return $this;
    }
    /**
     * Get ColumnNumber value
     * @return int|null
     */
    public function getColumnNumber()
    {
        return $this->ColumnNumber;
    }
    /**
     * Set ColumnNumber value
     * @param int $columnNumber
     * @return \StructType\CabinClassDetailType
     */
    public function setColumnNumber($columnNumber = null)
    {
        // validation for constraint: int
        if (!is_null($columnNumber) && !(is_int($columnNumber) || ctype_digit($columnNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($columnNumber, true), gettype($columnNumber)), __LINE__);
        }
        $this->ColumnNumber = $columnNumber;
        return $this;
    }
    /**
     * Get ColumnSpan value
     * @return int|null
     */
    public function getColumnSpan()
    {
        return $this->ColumnSpan;
    }
    /**
     * Set ColumnSpan value
     * @param int $columnSpan
     * @return \StructType\CabinClassDetailType
     */
    public function setColumnSpan($columnSpan = null)
    {
        // validation for constraint: int
        if (!is_null($columnSpan) && !(is_int($columnSpan) || ctype_digit($columnSpan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($columnSpan, true), gettype($columnSpan)), __LINE__);
        }
        $this->ColumnSpan = $columnSpan;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinClassDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
