<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinClassAvailabilityType StructType
 * Meta information extracted from the WSDL
 * - documentation: A listing of each seat within a cabin and the seat availability.
 * @subpackage Structs
 */
class CabinClassAvailabilityType extends AbstractStructBase
{
    /**
     * The SeatNumber
     * Meta information extracted from the WSDL
     * - documentation: The seat number that includes row number and seat section, e.g. "2C".
     * - use: optional
     * @var string
     */
    public $SeatNumber;
    /**
     * The AdvancePurchaseInd
     * Meta information extracted from the WSDL
     * - documentation: If true, advanced purchase is required for this seat.
     * - use: optional
     * @var bool
     */
    public $AdvancePurchaseInd;
    /**
     * The AvailableInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is available.
     * - use: optional
     * @var bool
     */
    public $AvailableInd;
    /**
     * The InoperativeInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is not operational.
     * - use: optional
     * @var bool
     */
    public $InoperativeInd;
    /**
     * The OccupiedInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is occupied and/or already reserved.
     * - use: optional
     * @var bool
     */
    public $OccupiedInd;
    /**
     * The PremiumInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is a premium seat that may be subjected to additional fees.
     * - use: optional
     * @var bool
     */
    public $PremiumInd;
    /**
     * Constructor method for CabinClassAvailabilityType
     * @uses CabinClassAvailabilityType::setSeatNumber()
     * @uses CabinClassAvailabilityType::setAdvancePurchaseInd()
     * @uses CabinClassAvailabilityType::setAvailableInd()
     * @uses CabinClassAvailabilityType::setInoperativeInd()
     * @uses CabinClassAvailabilityType::setOccupiedInd()
     * @uses CabinClassAvailabilityType::setPremiumInd()
     * @param string $seatNumber
     * @param bool $advancePurchaseInd
     * @param bool $availableInd
     * @param bool $inoperativeInd
     * @param bool $occupiedInd
     * @param bool $premiumInd
     */
    public function __construct($seatNumber = null, $advancePurchaseInd = null, $availableInd = null, $inoperativeInd = null, $occupiedInd = null, $premiumInd = null)
    {
        $this
            ->setSeatNumber($seatNumber)
            ->setAdvancePurchaseInd($advancePurchaseInd)
            ->setAvailableInd($availableInd)
            ->setInoperativeInd($inoperativeInd)
            ->setOccupiedInd($occupiedInd)
            ->setPremiumInd($premiumInd);
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \StructType\CabinClassAvailabilityType
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNumber, true), gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get AdvancePurchaseInd value
     * @return bool|null
     */
    public function getAdvancePurchaseInd()
    {
        return $this->AdvancePurchaseInd;
    }
    /**
     * Set AdvancePurchaseInd value
     * @param bool $advancePurchaseInd
     * @return \StructType\CabinClassAvailabilityType
     */
    public function setAdvancePurchaseInd($advancePurchaseInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($advancePurchaseInd) && !is_bool($advancePurchaseInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advancePurchaseInd, true), gettype($advancePurchaseInd)), __LINE__);
        }
        $this->AdvancePurchaseInd = $advancePurchaseInd;
        return $this;
    }
    /**
     * Get AvailableInd value
     * @return bool|null
     */
    public function getAvailableInd()
    {
        return $this->AvailableInd;
    }
    /**
     * Set AvailableInd value
     * @param bool $availableInd
     * @return \StructType\CabinClassAvailabilityType
     */
    public function setAvailableInd($availableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableInd) && !is_bool($availableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableInd, true), gettype($availableInd)), __LINE__);
        }
        $this->AvailableInd = $availableInd;
        return $this;
    }
    /**
     * Get InoperativeInd value
     * @return bool|null
     */
    public function getInoperativeInd()
    {
        return $this->InoperativeInd;
    }
    /**
     * Set InoperativeInd value
     * @param bool $inoperativeInd
     * @return \StructType\CabinClassAvailabilityType
     */
    public function setInoperativeInd($inoperativeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($inoperativeInd) && !is_bool($inoperativeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inoperativeInd, true), gettype($inoperativeInd)), __LINE__);
        }
        $this->InoperativeInd = $inoperativeInd;
        return $this;
    }
    /**
     * Get OccupiedInd value
     * @return bool|null
     */
    public function getOccupiedInd()
    {
        return $this->OccupiedInd;
    }
    /**
     * Set OccupiedInd value
     * @param bool $occupiedInd
     * @return \StructType\CabinClassAvailabilityType
     */
    public function setOccupiedInd($occupiedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($occupiedInd) && !is_bool($occupiedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($occupiedInd, true), gettype($occupiedInd)), __LINE__);
        }
        $this->OccupiedInd = $occupiedInd;
        return $this;
    }
    /**
     * Get PremiumInd value
     * @return bool|null
     */
    public function getPremiumInd()
    {
        return $this->PremiumInd;
    }
    /**
     * Set PremiumInd value
     * @param bool $premiumInd
     * @return \StructType\CabinClassAvailabilityType
     */
    public function setPremiumInd($premiumInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($premiumInd) && !is_bool($premiumInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($premiumInd, true), gettype($premiumInd)), __LINE__);
        }
        $this->PremiumInd = $premiumInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinClassAvailabilityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
