<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinAvailabilityType StructType
 * Meta information extracted from the WSDL
 * - documentation: Construct for holding cabin class information, such as seat availability or meal codes. Can be up to three of these per flight segment or air leg - First, Business and Economy.
 * @subpackage Structs
 */
class CabinAvailabilityType extends AbstractStructBase
{
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: A section of an aircraft identified by the service level (e.g., First, Business, Economy.)
     * - use: required
     * @var string
     */
    public $CabinType;
    /**
     * The Meal
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Meal[]
     */
    public $Meal;
    /**
     * The BaggageAllowance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaggageAllowance
     */
    public $BaggageAllowance;
    /**
     * The Entertainment
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Entertainment[]
     */
    public $Entertainment;
    /**
     * The FlightLoadInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FlightLoadInfo
     */
    public $FlightLoadInfo;
    /**
     * The CabinCapacity
     * Meta information extracted from the WSDL
     * - documentation: The total quantity of physical seats in the cabin.
     * - use: optional
     * @var int
     */
    public $CabinCapacity;
    /**
     * Constructor method for CabinAvailabilityType
     * @uses CabinAvailabilityType::setCabinType()
     * @uses CabinAvailabilityType::setMeal()
     * @uses CabinAvailabilityType::setBaggageAllowance()
     * @uses CabinAvailabilityType::setEntertainment()
     * @uses CabinAvailabilityType::setFlightLoadInfo()
     * @uses CabinAvailabilityType::setCabinCapacity()
     * @param string $cabinType
     * @param \StructType\Meal[] $meal
     * @param \StructType\BaggageAllowance $baggageAllowance
     * @param \StructType\Entertainment[] $entertainment
     * @param \StructType\FlightLoadInfo $flightLoadInfo
     * @param int $cabinCapacity
     */
    public function __construct($cabinType = null, array $meal = array(), \StructType\BaggageAllowance $baggageAllowance = null, array $entertainment = array(), \StructType\FlightLoadInfo $flightLoadInfo = null, $cabinCapacity = null)
    {
        $this
            ->setCabinType($cabinType)
            ->setMeal($meal)
            ->setBaggageAllowance($baggageAllowance)
            ->setEntertainment($entertainment)
            ->setFlightLoadInfo($flightLoadInfo)
            ->setCabinCapacity($cabinCapacity);
    }
    /**
     * Get CabinType value
     * @return string
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \StructType\CabinAvailabilityType
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($cabinType) ? implode(', ', $cabinType) : var_export($cabinType, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get Meal value
     * @return \StructType\Meal[]|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * This method is responsible for validating the values passed to the setMeal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealForArrayConstraintsFromSetMeal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinAvailabilityTypeMealItem) {
            // validation for constraint: itemType
            if (!$cabinAvailabilityTypeMealItem instanceof \StructType\Meal) {
                $invalidValues[] = is_object($cabinAvailabilityTypeMealItem) ? get_class($cabinAvailabilityTypeMealItem) : sprintf('%s(%s)', gettype($cabinAvailabilityTypeMealItem), var_export($cabinAvailabilityTypeMealItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Meal property can only contain items of type \StructType\Meal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Meal value
     * @throws \InvalidArgumentException
     * @param \StructType\Meal[] $meal
     * @return \StructType\CabinAvailabilityType
     */
    public function setMeal(array $meal = array())
    {
        // validation for constraint: array
        if ('' !== ($mealArrayErrorMessage = self::validateMealForArrayConstraintsFromSetMeal($meal))) {
            throw new \InvalidArgumentException($mealArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($meal) && count($meal) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($meal)), __LINE__);
        }
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Add item to Meal value
     * @throws \InvalidArgumentException
     * @param \StructType\Meal $item
     * @return \StructType\CabinAvailabilityType
     */
    public function addToMeal(\StructType\Meal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Meal) {
            throw new \InvalidArgumentException(sprintf('The Meal property can only contain items of type \StructType\Meal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Meal) && count($this->Meal) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Meal)), __LINE__);
        }
        $this->Meal[] = $item;
        return $this;
    }
    /**
     * Get BaggageAllowance value
     * @return \StructType\BaggageAllowance|null
     */
    public function getBaggageAllowance()
    {
        return $this->BaggageAllowance;
    }
    /**
     * Set BaggageAllowance value
     * @param \StructType\BaggageAllowance $baggageAllowance
     * @return \StructType\CabinAvailabilityType
     */
    public function setBaggageAllowance(\StructType\BaggageAllowance $baggageAllowance = null)
    {
        $this->BaggageAllowance = $baggageAllowance;
        return $this;
    }
    /**
     * Get Entertainment value
     * @return \StructType\Entertainment[]|null
     */
    public function getEntertainment()
    {
        return $this->Entertainment;
    }
    /**
     * This method is responsible for validating the values passed to the setEntertainment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEntertainment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEntertainmentForArrayConstraintsFromSetEntertainment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinAvailabilityTypeEntertainmentItem) {
            // validation for constraint: itemType
            if (!$cabinAvailabilityTypeEntertainmentItem instanceof \StructType\Entertainment) {
                $invalidValues[] = is_object($cabinAvailabilityTypeEntertainmentItem) ? get_class($cabinAvailabilityTypeEntertainmentItem) : sprintf('%s(%s)', gettype($cabinAvailabilityTypeEntertainmentItem), var_export($cabinAvailabilityTypeEntertainmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Entertainment property can only contain items of type \StructType\Entertainment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Entertainment value
     * @throws \InvalidArgumentException
     * @param \StructType\Entertainment[] $entertainment
     * @return \StructType\CabinAvailabilityType
     */
    public function setEntertainment(array $entertainment = array())
    {
        // validation for constraint: array
        if ('' !== ($entertainmentArrayErrorMessage = self::validateEntertainmentForArrayConstraintsFromSetEntertainment($entertainment))) {
            throw new \InvalidArgumentException($entertainmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($entertainment) && count($entertainment) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($entertainment)), __LINE__);
        }
        $this->Entertainment = $entertainment;
        return $this;
    }
    /**
     * Add item to Entertainment value
     * @throws \InvalidArgumentException
     * @param \StructType\Entertainment $item
     * @return \StructType\CabinAvailabilityType
     */
    public function addToEntertainment(\StructType\Entertainment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Entertainment) {
            throw new \InvalidArgumentException(sprintf('The Entertainment property can only contain items of type \StructType\Entertainment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Entertainment) && count($this->Entertainment) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Entertainment)), __LINE__);
        }
        $this->Entertainment[] = $item;
        return $this;
    }
    /**
     * Get FlightLoadInfo value
     * @return \StructType\FlightLoadInfo|null
     */
    public function getFlightLoadInfo()
    {
        return $this->FlightLoadInfo;
    }
    /**
     * Set FlightLoadInfo value
     * @param \StructType\FlightLoadInfo $flightLoadInfo
     * @return \StructType\CabinAvailabilityType
     */
    public function setFlightLoadInfo(\StructType\FlightLoadInfo $flightLoadInfo = null)
    {
        $this->FlightLoadInfo = $flightLoadInfo;
        return $this;
    }
    /**
     * Get CabinCapacity value
     * @return int|null
     */
    public function getCabinCapacity()
    {
        return $this->CabinCapacity;
    }
    /**
     * Set CabinCapacity value
     * @param int $cabinCapacity
     * @return \StructType\CabinAvailabilityType
     */
    public function setCabinCapacity($cabinCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($cabinCapacity) && !(is_int($cabinCapacity) || ctype_digit($cabinCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabinCapacity, true), gettype($cabinCapacity)), __LINE__);
        }
        $this->CabinCapacity = $cabinCapacity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinAvailabilityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
