<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinAvailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides a code and/or name for a cabin. | Identifies a section of an aircraft, possibly providing extra services.
 * @subpackage Structs
 */
class CabinAvailType extends AbstractStructBase
{
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - documentation: Specifies seat availability by class withn a cabin
     * - maxOccurs: 26
     * @var mixed[]
     */
    public $Seat;
    /**
     * The BaggageAllowance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaggageAllowance
     */
    public $BaggageAllowance;
    /**
     * The Meal
     * Meta information extracted from the WSDL
     * - documentation: Specifies the meal provided.
     * - use: optional
     * @var string
     */
    public $Meal;
    /**
     * Constructor method for CabinAvailType
     * @uses CabinAvailType::setSeat()
     * @uses CabinAvailType::setBaggageAllowance()
     * @uses CabinAvailType::setMeal()
     * @param mixed[] $seat
     * @param \StructType\BaggageAllowance $baggageAllowance
     * @param string $meal
     */
    public function __construct(array $seat = array(), \StructType\BaggageAllowance $baggageAllowance = null, $meal = null)
    {
        $this
            ->setSeat($seat)
            ->setBaggageAllowance($baggageAllowance)
            ->setMeal($meal);
    }
    /**
     * Get Seat value
     * @return mixed[]|null
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * This method is responsible for validating the values passed to the setSeat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatForArrayConstraintsFromSetSeat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinAvailTypeSeatItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cabinAvailTypeSeatItem) ? get_class($cabinAvailTypeSeatItem) : sprintf('%s(%s)', gettype($cabinAvailTypeSeatItem), var_export($cabinAvailTypeSeatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Seat property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Seat value
     * @throws \InvalidArgumentException
     * @param mixed[] $seat
     * @return \StructType\CabinAvailType
     */
    public function setSeat(array $seat = array())
    {
        // validation for constraint: array
        if ('' !== ($seatArrayErrorMessage = self::validateSeatForArrayConstraintsFromSetSeat($seat))) {
            throw new \InvalidArgumentException($seatArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(26)
        if (is_array($seat) && count($seat) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 26', count($seat)), __LINE__);
        }
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Add item to Seat value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CabinAvailType
     */
    public function addToSeat($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Seat property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(26)
        if (is_array($this->Seat) && count($this->Seat) >= 26) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 26', count($this->Seat)), __LINE__);
        }
        $this->Seat[] = $item;
        return $this;
    }
    /**
     * Get BaggageAllowance value
     * @return \StructType\BaggageAllowance|null
     */
    public function getBaggageAllowance()
    {
        return $this->BaggageAllowance;
    }
    /**
     * Set BaggageAllowance value
     * @param \StructType\BaggageAllowance $baggageAllowance
     * @return \StructType\CabinAvailType
     */
    public function setBaggageAllowance(\StructType\BaggageAllowance $baggageAllowance = null)
    {
        $this->BaggageAllowance = $baggageAllowance;
        return $this;
    }
    /**
     * Get Meal value
     * @return string|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * Set Meal value
     * @uses \EnumType\MealServiceType::valueIsValid()
     * @uses \EnumType\MealServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $meal
     * @return \StructType\CabinAvailType
     */
    public function setMeal($meal = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MealServiceType::valueIsValid($meal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MealServiceType', is_array($meal) ? implode(', ', $meal) : var_export($meal, true), implode(', ', \EnumType\MealServiceType::getValidValues())), __LINE__);
        }
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinAvailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
