<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines bus Information.
 * @subpackage Structs
 */
class BusInfoType extends AbstractStructBase
{
    /**
     * The Bus
     * Meta information extracted from the WSDL
     * - documentation: Identification and classification information of the bus.
     * @var mixed
     */
    public $Bus;
    /**
     * The ValidDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ValidDate
     */
    public $ValidDate;
    /**
     * The DelayTime
     * Meta information extracted from the WSDL
     * - documentation: The amount of time the bus is delayed (in seconds.)
     * - use: optional
     * @var int
     */
    public $DelayTime;
    /**
     * The ScheduleCode
     * Meta information extracted from the WSDL
     * - documentation: The schedule code for the bus. Refer to OpenTravel code list Train Schedule Code (TSC).
     * - use: optional
     * @var string
     */
    public $ScheduleCode;
    /**
     * Constructor method for BusInfoType
     * @uses BusInfoType::setBus()
     * @uses BusInfoType::setValidDate()
     * @uses BusInfoType::setDelayTime()
     * @uses BusInfoType::setScheduleCode()
     * @param mixed $bus
     * @param \StructType\ValidDate $validDate
     * @param int $delayTime
     * @param string $scheduleCode
     */
    public function __construct($bus = null, \StructType\ValidDate $validDate = null, $delayTime = null, $scheduleCode = null)
    {
        $this
            ->setBus($bus)
            ->setValidDate($validDate)
            ->setDelayTime($delayTime)
            ->setScheduleCode($scheduleCode);
    }
    /**
     * Get Bus value
     * @return mixed|null
     */
    public function getBus()
    {
        return $this->Bus;
    }
    /**
     * Set Bus value
     * @param mixed $bus
     * @return \StructType\BusInfoType
     */
    public function setBus($bus = null)
    {
        $this->Bus = $bus;
        return $this;
    }
    /**
     * Get ValidDate value
     * @return \StructType\ValidDate|null
     */
    public function getValidDate()
    {
        return $this->ValidDate;
    }
    /**
     * Set ValidDate value
     * @param \StructType\ValidDate $validDate
     * @return \StructType\BusInfoType
     */
    public function setValidDate(\StructType\ValidDate $validDate = null)
    {
        $this->ValidDate = $validDate;
        return $this;
    }
    /**
     * Get DelayTime value
     * @return int|null
     */
    public function getDelayTime()
    {
        return $this->DelayTime;
    }
    /**
     * Set DelayTime value
     * @param int $delayTime
     * @return \StructType\BusInfoType
     */
    public function setDelayTime($delayTime = null)
    {
        // validation for constraint: int
        if (!is_null($delayTime) && !(is_int($delayTime) || ctype_digit($delayTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($delayTime, true), gettype($delayTime)), __LINE__);
        }
        $this->DelayTime = $delayTime;
        return $this;
    }
    /**
     * Get ScheduleCode value
     * @return string|null
     */
    public function getScheduleCode()
    {
        return $this->ScheduleCode;
    }
    /**
     * Set ScheduleCode value
     * @param string $scheduleCode
     * @return \StructType\BusInfoType
     */
    public function setScheduleCode($scheduleCode = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleCode) && !is_string($scheduleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleCode, true), gettype($scheduleCode)), __LINE__);
        }
        $this->ScheduleCode = $scheduleCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
