<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Brands StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of Brands.
 * @subpackage Structs
 */
class Brands extends AbstractStructBase
{
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Brand[]
     */
    public $Brand;
    /**
     * Constructor method for Brands
     * @uses Brands::setBrand()
     * @param \StructType\Brand[] $brand
     */
    public function __construct(array $brand = array())
    {
        $this
            ->setBrand($brand);
    }
    /**
     * Get Brand value
     * @return \StructType\Brand[]|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * This method is responsible for validating the values passed to the setBrand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBrand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBrandForArrayConstraintsFromSetBrand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $brandsBrandItem) {
            // validation for constraint: itemType
            if (!$brandsBrandItem instanceof \StructType\Brand) {
                $invalidValues[] = is_object($brandsBrandItem) ? get_class($brandsBrandItem) : sprintf('%s(%s)', gettype($brandsBrandItem), var_export($brandsBrandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Brand property can only contain items of type \StructType\Brand, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Brand value
     * @throws \InvalidArgumentException
     * @param \StructType\Brand[] $brand
     * @return \StructType\Brands
     */
    public function setBrand(array $brand = array())
    {
        // validation for constraint: array
        if ('' !== ($brandArrayErrorMessage = self::validateBrandForArrayConstraintsFromSetBrand($brand))) {
            throw new \InvalidArgumentException($brandArrayErrorMessage, __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Add item to Brand value
     * @throws \InvalidArgumentException
     * @param \StructType\Brand $item
     * @return \StructType\Brands
     */
    public function addToBrand(\StructType\Brand $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Brand) {
            throw new \InvalidArgumentException(sprintf('The Brand property can only contain items of type \StructType\Brand, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Brand[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Brands
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
