<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: An extensible list of unique ID types.
 * @subpackage Structs
 */
class BookingReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The booking reference ID, e.g. PNR.
     * - use: required
     * @var string
     */
    public $ID;
    /**
     * The UniqueID_Type
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID_Type;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - documentation: Associated company information.
     * - minOccurs: 0
     * @var mixed
     */
    public $Company;
    /**
     * The Traveler
     * Meta information extracted from the WSDL
     * - documentation: Associated traveler information.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Traveler;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The Instance
     * Meta information extracted from the WSDL
     * - documentation: The identification of a record as it exists at a point in time. An instance is used in update messages where the sender must assure the server that the update sent refers to the most recent modification level of the object being
     * updated.
     * - use: optional
     * @var string
     */
    public $Instance;
    /**
     * The AssociatedID
     * Meta information extracted from the WSDL
     * - documentation: An associated ID, such as a conjunctive ticket number.
     * - use: optional
     * @var string
     */
    public $AssociatedID;
    /**
     * Constructor method for BookingReferenceType
     * @uses BookingReferenceType::setID()
     * @uses BookingReferenceType::setUniqueID_Type()
     * @uses BookingReferenceType::setCompany()
     * @uses BookingReferenceType::setTraveler()
     * @uses BookingReferenceType::setTPA_Extensions()
     * @uses BookingReferenceType::setInstance()
     * @uses BookingReferenceType::setAssociatedID()
     * @param string $iD
     * @param \StructType\UniqueID_Type $uniqueID_Type
     * @param mixed $company
     * @param mixed[] $traveler
     * @param mixed $tPA_Extensions
     * @param string $instance
     * @param string $associatedID
     */
    public function __construct($iD = null, \StructType\UniqueID_Type $uniqueID_Type = null, $company = null, array $traveler = array(), $tPA_Extensions = null, $instance = null, $associatedID = null)
    {
        $this
            ->setID($iD)
            ->setUniqueID_Type($uniqueID_Type)
            ->setCompany($company)
            ->setTraveler($traveler)
            ->setTPA_Extensions($tPA_Extensions)
            ->setInstance($instance)
            ->setAssociatedID($associatedID);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\BookingReferenceType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get UniqueID_Type value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID_Type()
    {
        return $this->UniqueID_Type;
    }
    /**
     * Set UniqueID_Type value
     * @param \StructType\UniqueID_Type $uniqueID_Type
     * @return \StructType\BookingReferenceType
     */
    public function setUniqueID_Type(\StructType\UniqueID_Type $uniqueID_Type = null)
    {
        $this->UniqueID_Type = $uniqueID_Type;
        return $this;
    }
    /**
     * Get Company value
     * @return mixed|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param mixed $company
     * @return \StructType\BookingReferenceType
     */
    public function setCompany($company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Traveler value
     * @return mixed[]|null
     */
    public function getTraveler()
    {
        return $this->Traveler;
    }
    /**
     * This method is responsible for validating the values passed to the setTraveler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTraveler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerForArrayConstraintsFromSetTraveler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingReferenceTypeTravelerItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($bookingReferenceTypeTravelerItem) ? get_class($bookingReferenceTypeTravelerItem) : sprintf('%s(%s)', gettype($bookingReferenceTypeTravelerItem), var_export($bookingReferenceTypeTravelerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Traveler property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Traveler value
     * @throws \InvalidArgumentException
     * @param mixed[] $traveler
     * @return \StructType\BookingReferenceType
     */
    public function setTraveler(array $traveler = array())
    {
        // validation for constraint: array
        if ('' !== ($travelerArrayErrorMessage = self::validateTravelerForArrayConstraintsFromSetTraveler($traveler))) {
            throw new \InvalidArgumentException($travelerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($traveler) && count($traveler) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($traveler)), __LINE__);
        }
        $this->Traveler = $traveler;
        return $this;
    }
    /**
     * Add item to Traveler value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\BookingReferenceType
     */
    public function addToTraveler($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Traveler property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Traveler) && count($this->Traveler) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Traveler)), __LINE__);
        }
        $this->Traveler[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\BookingReferenceType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Instance value
     * @return string|null
     */
    public function getInstance()
    {
        return $this->Instance;
    }
    /**
     * Set Instance value
     * @param string $instance
     * @return \StructType\BookingReferenceType
     */
    public function setInstance($instance = null)
    {
        // validation for constraint: string
        if (!is_null($instance) && !is_string($instance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instance, true), gettype($instance)), __LINE__);
        }
        $this->Instance = $instance;
        return $this;
    }
    /**
     * Get AssociatedID value
     * @return string|null
     */
    public function getAssociatedID()
    {
        return $this->AssociatedID;
    }
    /**
     * Set AssociatedID value
     * @param string $associatedID
     * @return \StructType\BookingReferenceType
     */
    public function setAssociatedID($associatedID = null)
    {
        // validation for constraint: string
        if (!is_null($associatedID) && !is_string($associatedID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedID, true), gettype($associatedID)), __LINE__);
        }
        $this->AssociatedID = $associatedID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
