<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingReferenceID StructType
 * Meta information extracted from the WSDL
 * - documentation: The booking or confirmation number for which charges are being authorized. | Optional field available for use by trading partners as determined by their needs.
 * @subpackage Structs
 */
class BookingReferenceID extends UniqueID_Type
{
    /**
     * The FlightRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: This provides a list of flight segment RPHs associated with a specific Booking Reference ID.
     * - use: optional
     * @var list
     */
    public $FlightRefNumberRPHList;
    /**
     * The IgnoreReservationInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the PNR should not be updated with the authorization information returned.
     * - use: optional
     * @var bool
     */
    public $IgnoreReservationInd;
    /**
     * Constructor method for BookingReferenceID
     * @uses BookingReferenceID::setFlightRefNumberRPHList()
     * @uses BookingReferenceID::setIgnoreReservationInd()
     * @param list $flightRefNumberRPHList
     * @param bool $ignoreReservationInd
     */
    public function __construct(list $flightRefNumberRPHList = null, $ignoreReservationInd = null)
    {
        $this
            ->setFlightRefNumberRPHList($flightRefNumberRPHList)
            ->setIgnoreReservationInd($ignoreReservationInd);
    }
    /**
     * Get FlightRefNumberRPHList value
     * @return list|null
     */
    public function getFlightRefNumberRPHList()
    {
        return $this->FlightRefNumberRPHList;
    }
    /**
     * Set FlightRefNumberRPHList value
     * @param list $flightRefNumberRPHList
     * @return \StructType\BookingReferenceID
     */
    public function setFlightRefNumberRPHList(list $flightRefNumberRPHList = null)
    {
        $this->FlightRefNumberRPHList = $flightRefNumberRPHList;
        return $this;
    }
    /**
     * Get IgnoreReservationInd value
     * @return bool|null
     */
    public function getIgnoreReservationInd()
    {
        return $this->IgnoreReservationInd;
    }
    /**
     * Set IgnoreReservationInd value
     * @param bool $ignoreReservationInd
     * @return \StructType\BookingReferenceID
     */
    public function setIgnoreReservationInd($ignoreReservationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreReservationInd) && !is_bool($ignoreReservationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreReservationInd, true), gettype($ignoreReservationInd)), __LINE__);
        }
        $this->IgnoreReservationInd = $ignoreReservationInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingReferenceID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
