<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingInstruction StructType
 * Meta information extracted from the WSDL
 * - documentation: Booking and upgrade instructions.
 * @subpackage Structs
 */
class BookingInstruction extends AbstractStructBase
{
    /**
     * The SSR_Info
     * Meta information extracted from the WSDL
     * - documentation: Special service request information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SSR_Info;
    /**
     * The OSI_Info
     * Meta information extracted from the WSDL
     * - documentation: Other service information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $OSI_Info;
    /**
     * The Upgrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Upgrade
     */
    public $Upgrade;
    /**
     * The BookingMethod
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BookingMethod;
    /**
     * The EMD_Type
     * @var string
     */
    public $EMD_Type;
    /**
     * Constructor method for BookingInstruction
     * @uses BookingInstruction::setSSR_Info()
     * @uses BookingInstruction::setOSI_Info()
     * @uses BookingInstruction::setUpgrade()
     * @uses BookingInstruction::setBookingMethod()
     * @uses BookingInstruction::setEMD_Type()
     * @param mixed[] $sSR_Info
     * @param mixed[] $oSI_Info
     * @param \StructType\Upgrade $upgrade
     * @param string $bookingMethod
     * @param string $eMD_Type
     */
    public function __construct(array $sSR_Info = array(), array $oSI_Info = array(), \StructType\Upgrade $upgrade = null, $bookingMethod = null, $eMD_Type = null)
    {
        $this
            ->setSSR_Info($sSR_Info)
            ->setOSI_Info($oSI_Info)
            ->setUpgrade($upgrade)
            ->setBookingMethod($bookingMethod)
            ->setEMD_Type($eMD_Type);
    }
    /**
     * Get SSR_Info value
     * @return mixed[]|null
     */
    public function getSSR_Info()
    {
        return $this->SSR_Info;
    }
    /**
     * This method is responsible for validating the values passed to the setSSR_Info method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSSR_Info method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSSR_InfoForArrayConstraintsFromSetSSR_Info(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingInstructionSSR_InfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($bookingInstructionSSR_InfoItem) ? get_class($bookingInstructionSSR_InfoItem) : sprintf('%s(%s)', gettype($bookingInstructionSSR_InfoItem), var_export($bookingInstructionSSR_InfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SSR_Info property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SSR_Info value
     * @throws \InvalidArgumentException
     * @param mixed[] $sSR_Info
     * @return \StructType\BookingInstruction
     */
    public function setSSR_Info(array $sSR_Info = array())
    {
        // validation for constraint: array
        if ('' !== ($sSR_InfoArrayErrorMessage = self::validateSSR_InfoForArrayConstraintsFromSetSSR_Info($sSR_Info))) {
            throw new \InvalidArgumentException($sSR_InfoArrayErrorMessage, __LINE__);
        }
        $this->SSR_Info = $sSR_Info;
        return $this;
    }
    /**
     * Add item to SSR_Info value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\BookingInstruction
     */
    public function addToSSR_Info($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SSR_Info property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SSR_Info[] = $item;
        return $this;
    }
    /**
     * Get OSI_Info value
     * @return mixed[]|null
     */
    public function getOSI_Info()
    {
        return $this->OSI_Info;
    }
    /**
     * This method is responsible for validating the values passed to the setOSI_Info method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOSI_Info method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOSI_InfoForArrayConstraintsFromSetOSI_Info(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingInstructionOSI_InfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($bookingInstructionOSI_InfoItem) ? get_class($bookingInstructionOSI_InfoItem) : sprintf('%s(%s)', gettype($bookingInstructionOSI_InfoItem), var_export($bookingInstructionOSI_InfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OSI_Info property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OSI_Info value
     * @throws \InvalidArgumentException
     * @param mixed[] $oSI_Info
     * @return \StructType\BookingInstruction
     */
    public function setOSI_Info(array $oSI_Info = array())
    {
        // validation for constraint: array
        if ('' !== ($oSI_InfoArrayErrorMessage = self::validateOSI_InfoForArrayConstraintsFromSetOSI_Info($oSI_Info))) {
            throw new \InvalidArgumentException($oSI_InfoArrayErrorMessage, __LINE__);
        }
        $this->OSI_Info = $oSI_Info;
        return $this;
    }
    /**
     * Add item to OSI_Info value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\BookingInstruction
     */
    public function addToOSI_Info($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The OSI_Info property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OSI_Info[] = $item;
        return $this;
    }
    /**
     * Get Upgrade value
     * @return \StructType\Upgrade|null
     */
    public function getUpgrade()
    {
        return $this->Upgrade;
    }
    /**
     * Set Upgrade value
     * @param \StructType\Upgrade $upgrade
     * @return \StructType\BookingInstruction
     */
    public function setUpgrade(\StructType\Upgrade $upgrade = null)
    {
        $this->Upgrade = $upgrade;
        return $this;
    }
    /**
     * Get BookingMethod value
     * @return string|null
     */
    public function getBookingMethod()
    {
        return $this->BookingMethod;
    }
    /**
     * Set BookingMethod value
     * @param string $bookingMethod
     * @return \StructType\BookingInstruction
     */
    public function setBookingMethod($bookingMethod = null)
    {
        // validation for constraint: string
        if (!is_null($bookingMethod) && !is_string($bookingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingMethod, true), gettype($bookingMethod)), __LINE__);
        }
        $this->BookingMethod = $bookingMethod;
        return $this;
    }
    /**
     * Get EMD_Type value
     * @return string|null
     */
    public function getEMD_Type()
    {
        return $this->EMD_Type;
    }
    /**
     * Set EMD_Type value
     * @param string $eMD_Type
     * @return \StructType\BookingInstruction
     */
    public function setEMD_Type($eMD_Type = null)
    {
        // validation for constraint: string
        if (!is_null($eMD_Type) && !is_string($eMD_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMD_Type, true), gettype($eMD_Type)), __LINE__);
        }
        $this->EMD_Type = $eMD_Type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingInstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
