<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookedTrainSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the information needed to describe a train segment that has been booked as part of a reservation.
 * @subpackage Structs
 */
class BookedTrainSegmentType extends TrainSegmentType
{
    /**
     * The BookStatus
     * Meta information extracted from the WSDL
     * - documentation: The booking status.
     * - use: required
     * @var string
     */
    public $BookStatus;
    /**
     * The ClassCode
     * Meta information extracted from the WSDL
     * - documentation: The class of inventory controlled services available.
     * - minOccurs: 0
     * @var mixed
     */
    public $ClassCode;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Any special comments on the segment.
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Comment;
    /**
     * The Assignment
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Assignment[]
     */
    public $Assignment;
    /**
     * The MarriageGrp
     * Meta information extracted from the WSDL
     * - documentation: Many rail suppliers link connection trips together by terming them married segments. When two or more segments are married, they must be processed as one unit. The segments must be moved, cancelled, and/or priced together. The value
     * of the marriage group must be the same for all segments.
     * - minOccurs: 0
     * @var mixed
     */
    public $MarriageGrp;
    /**
     * The TicketStatus
     * Meta information extracted from the WSDL
     * - documentation: The ticket status.
     * - use: optional
     * @var string
     */
    public $TicketStatus;
    /**
     * Constructor method for BookedTrainSegmentType
     * @uses BookedTrainSegmentType::setBookStatus()
     * @uses BookedTrainSegmentType::setClassCode()
     * @uses BookedTrainSegmentType::setComment()
     * @uses BookedTrainSegmentType::setAssignment()
     * @uses BookedTrainSegmentType::setMarriageGrp()
     * @uses BookedTrainSegmentType::setTicketStatus()
     * @param string $bookStatus
     * @param mixed $classCode
     * @param mixed[] $comment
     * @param \StructType\Assignment[] $assignment
     * @param mixed $marriageGrp
     * @param string $ticketStatus
     */
    public function __construct($bookStatus = null, $classCode = null, array $comment = array(), array $assignment = array(), $marriageGrp = null, $ticketStatus = null)
    {
        $this
            ->setBookStatus($bookStatus)
            ->setClassCode($classCode)
            ->setComment($comment)
            ->setAssignment($assignment)
            ->setMarriageGrp($marriageGrp)
            ->setTicketStatus($ticketStatus);
    }
    /**
     * Get BookStatus value
     * @return string
     */
    public function getBookStatus()
    {
        return $this->BookStatus;
    }
    /**
     * Set BookStatus value
     * @param string $bookStatus
     * @return \StructType\BookedTrainSegmentType
     */
    public function setBookStatus($bookStatus = null)
    {
        // validation for constraint: string
        if (!is_null($bookStatus) && !is_string($bookStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookStatus, true), gettype($bookStatus)), __LINE__);
        }
        $this->BookStatus = $bookStatus;
        return $this;
    }
    /**
     * Get ClassCode value
     * @return mixed|null
     */
    public function getClassCode()
    {
        return $this->ClassCode;
    }
    /**
     * Set ClassCode value
     * @param mixed $classCode
     * @return \StructType\BookedTrainSegmentType
     */
    public function setClassCode($classCode = null)
    {
        $this->ClassCode = $classCode;
        return $this;
    }
    /**
     * Get Comment value
     * @return mixed[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * This method is responsible for validating the values passed to the setComment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommentForArrayConstraintsFromSetComment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookedTrainSegmentTypeCommentItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($bookedTrainSegmentTypeCommentItem) ? get_class($bookedTrainSegmentTypeCommentItem) : sprintf('%s(%s)', gettype($bookedTrainSegmentTypeCommentItem), var_export($bookedTrainSegmentTypeCommentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Comment property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param mixed[] $comment
     * @return \StructType\BookedTrainSegmentType
     */
    public function setComment(array $comment = array())
    {
        // validation for constraint: array
        if ('' !== ($commentArrayErrorMessage = self::validateCommentForArrayConstraintsFromSetComment($comment))) {
            throw new \InvalidArgumentException($commentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($comment) && count($comment) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\BookedTrainSegmentType
     */
    public function addToComment($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Comment) && count($this->Comment) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Comment)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get Assignment value
     * @return \StructType\Assignment[]|null
     */
    public function getAssignment()
    {
        return $this->Assignment;
    }
    /**
     * This method is responsible for validating the values passed to the setAssignment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssignment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssignmentForArrayConstraintsFromSetAssignment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookedTrainSegmentTypeAssignmentItem) {
            // validation for constraint: itemType
            if (!$bookedTrainSegmentTypeAssignmentItem instanceof \StructType\Assignment) {
                $invalidValues[] = is_object($bookedTrainSegmentTypeAssignmentItem) ? get_class($bookedTrainSegmentTypeAssignmentItem) : sprintf('%s(%s)', gettype($bookedTrainSegmentTypeAssignmentItem), var_export($bookedTrainSegmentTypeAssignmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Assignment property can only contain items of type \StructType\Assignment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Assignment value
     * @throws \InvalidArgumentException
     * @param \StructType\Assignment[] $assignment
     * @return \StructType\BookedTrainSegmentType
     */
    public function setAssignment(array $assignment = array())
    {
        // validation for constraint: array
        if ('' !== ($assignmentArrayErrorMessage = self::validateAssignmentForArrayConstraintsFromSetAssignment($assignment))) {
            throw new \InvalidArgumentException($assignmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($assignment) && count($assignment) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($assignment)), __LINE__);
        }
        $this->Assignment = $assignment;
        return $this;
    }
    /**
     * Add item to Assignment value
     * @throws \InvalidArgumentException
     * @param \StructType\Assignment $item
     * @return \StructType\BookedTrainSegmentType
     */
    public function addToAssignment(\StructType\Assignment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Assignment) {
            throw new \InvalidArgumentException(sprintf('The Assignment property can only contain items of type \StructType\Assignment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Assignment) && count($this->Assignment) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Assignment)), __LINE__);
        }
        $this->Assignment[] = $item;
        return $this;
    }
    /**
     * Get MarriageGrp value
     * @return mixed|null
     */
    public function getMarriageGrp()
    {
        return $this->MarriageGrp;
    }
    /**
     * Set MarriageGrp value
     * @param mixed $marriageGrp
     * @return \StructType\BookedTrainSegmentType
     */
    public function setMarriageGrp($marriageGrp = null)
    {
        $this->MarriageGrp = $marriageGrp;
        return $this;
    }
    /**
     * Get TicketStatus value
     * @return string|null
     */
    public function getTicketStatus()
    {
        return $this->TicketStatus;
    }
    /**
     * Set TicketStatus value
     * @param string $ticketStatus
     * @return \StructType\BookedTrainSegmentType
     */
    public function setTicketStatus($ticketStatus = null)
    {
        // validation for constraint: string
        if (!is_null($ticketStatus) && !is_string($ticketStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketStatus, true), gettype($ticketStatus)), __LINE__);
        }
        $this->TicketStatus = $ticketStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookedTrainSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
