<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlackoutDates StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies any Blackout Dates which are periods during which the hotel cannot guarantee rates and rooms availability due to peak occupancy.
 * @subpackage Structs
 */
class BlackoutDates extends AbstractStructBase
{
    /**
     * The BlackoutDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\BlackoutDate[]
     */
    public $BlackoutDate;
    /**
     * Constructor method for BlackoutDates
     * @uses BlackoutDates::setBlackoutDate()
     * @param \StructType\BlackoutDate[] $blackoutDate
     */
    public function __construct(array $blackoutDate = array())
    {
        $this
            ->setBlackoutDate($blackoutDate);
    }
    /**
     * Get BlackoutDate value
     * @return \StructType\BlackoutDate[]|null
     */
    public function getBlackoutDate()
    {
        return $this->BlackoutDate;
    }
    /**
     * This method is responsible for validating the values passed to the setBlackoutDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBlackoutDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBlackoutDateForArrayConstraintsFromSetBlackoutDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $blackoutDatesBlackoutDateItem) {
            // validation for constraint: itemType
            if (!$blackoutDatesBlackoutDateItem instanceof \StructType\BlackoutDate) {
                $invalidValues[] = is_object($blackoutDatesBlackoutDateItem) ? get_class($blackoutDatesBlackoutDateItem) : sprintf('%s(%s)', gettype($blackoutDatesBlackoutDateItem), var_export($blackoutDatesBlackoutDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BlackoutDate property can only contain items of type \StructType\BlackoutDate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BlackoutDate value
     * @throws \InvalidArgumentException
     * @param \StructType\BlackoutDate[] $blackoutDate
     * @return \StructType\BlackoutDates
     */
    public function setBlackoutDate(array $blackoutDate = array())
    {
        // validation for constraint: array
        if ('' !== ($blackoutDateArrayErrorMessage = self::validateBlackoutDateForArrayConstraintsFromSetBlackoutDate($blackoutDate))) {
            throw new \InvalidArgumentException($blackoutDateArrayErrorMessage, __LINE__);
        }
        $this->BlackoutDate = $blackoutDate;
        return $this;
    }
    /**
     * Add item to BlackoutDate value
     * @throws \InvalidArgumentException
     * @param \StructType\BlackoutDate $item
     * @return \StructType\BlackoutDates
     */
    public function addToBlackoutDate(\StructType\BlackoutDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BlackoutDate) {
            throw new \InvalidArgumentException(sprintf('The BlackoutDate property can only contain items of type \StructType\BlackoutDate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BlackoutDate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlackoutDates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
