<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlackoutDateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides blackout date information.
 * @subpackage Structs
 */
class BlackoutDateType extends AbstractStructBase
{
    /**
     * The BlackoutDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates black-out dates for the travel product/service.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $BlackoutDate;
    /**
     * Constructor method for BlackoutDateType
     * @uses BlackoutDateType::setBlackoutDate()
     * @param mixed[] $blackoutDate
     */
    public function __construct(array $blackoutDate = array())
    {
        $this
            ->setBlackoutDate($blackoutDate);
    }
    /**
     * Get BlackoutDate value
     * @return mixed[]|null
     */
    public function getBlackoutDate()
    {
        return $this->BlackoutDate;
    }
    /**
     * This method is responsible for validating the values passed to the setBlackoutDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBlackoutDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBlackoutDateForArrayConstraintsFromSetBlackoutDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $blackoutDateTypeBlackoutDateItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($blackoutDateTypeBlackoutDateItem) ? get_class($blackoutDateTypeBlackoutDateItem) : sprintf('%s(%s)', gettype($blackoutDateTypeBlackoutDateItem), var_export($blackoutDateTypeBlackoutDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BlackoutDate property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BlackoutDate value
     * @throws \InvalidArgumentException
     * @param mixed[] $blackoutDate
     * @return \StructType\BlackoutDateType
     */
    public function setBlackoutDate(array $blackoutDate = array())
    {
        // validation for constraint: array
        if ('' !== ($blackoutDateArrayErrorMessage = self::validateBlackoutDateForArrayConstraintsFromSetBlackoutDate($blackoutDate))) {
            throw new \InvalidArgumentException($blackoutDateArrayErrorMessage, __LINE__);
        }
        $this->BlackoutDate = $blackoutDate;
        return $this;
    }
    /**
     * Add item to BlackoutDate value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\BlackoutDateType
     */
    public function addToBlackoutDate($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The BlackoutDate property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BlackoutDate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlackoutDateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
