<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlackoutDate StructType
 * Meta information extracted from the WSDL
 * - documentation: A Blackout Date during which the hotel cannot guarantee rates and rooms availability due to peak occupancy.
 * @subpackage Structs
 */
class BlackoutDate extends DateTimeSpanType
{
    /**
     * The Description
     * @var \StructType\Description
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: A descriptive name that identifies the reason for the blackout, e.g : 2012 Olympic Games.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * Constructor method for BlackoutDate
     * @uses BlackoutDate::setDescription()
     * @uses BlackoutDate::setName()
     * @param \StructType\Description $description
     * @param string $name
     */
    public function __construct(\StructType\Description $description = null, $name = null)
    {
        $this
            ->setDescription($description)
            ->setName($name);
    }
    /**
     * Get Description value
     * @return \StructType\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Description $description
     * @return \StructType\BlackoutDate
     */
    public function setDescription(\StructType\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\BlackoutDate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlackoutDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
