<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingInstructionCode StructType
 * Meta information extracted from the WSDL
 * - documentation: The date and time for which the billing instruction applies. | Billing codes that apply to a set of instructions for a set of transactions that are routed to a designated folio.
 * @subpackage Structs
 */
class BillingInstructionCode extends AbstractStructBase
{
    /**
     * The BillingCode
     * Meta information extracted from the WSDL
     * - documentation: The individual billing code that applies to a set of instructions that are routed to a designated folio.
     * - use: required
     * @var string
     */
    public $BillingCode;
    /**
     * The ResGuestRPH
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ResGuestRPH[]
     */
    public $ResGuestRPH;
    /**
     * The BillingType
     * Meta information extracted from the WSDL
     * - documentation: Used to define the type of the BillingCode, such as group, corporate and casino. Refer to OpenTravel Code List Reservation Billing Type (RBT).
     * - use: optional
     * @var string
     */
    public $BillingType;
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - documentation: The authorization code associated with the billing code.
     * - use: optional
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A short description of the billing code or instructions.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - documentation: Identifies the account number where the charges will be routed.
     * - use: optional
     * @var string
     */
    public $AccountNumber;
    /**
     * Constructor method for BillingInstructionCode
     * @uses BillingInstructionCode::setBillingCode()
     * @uses BillingInstructionCode::setResGuestRPH()
     * @uses BillingInstructionCode::setBillingType()
     * @uses BillingInstructionCode::setAuthorizationCode()
     * @uses BillingInstructionCode::setDescription()
     * @uses BillingInstructionCode::setAccountNumber()
     * @param string $billingCode
     * @param \StructType\ResGuestRPH[] $resGuestRPH
     * @param string $billingType
     * @param string $authorizationCode
     * @param string $description
     * @param string $accountNumber
     */
    public function __construct($billingCode = null, array $resGuestRPH = array(), $billingType = null, $authorizationCode = null, $description = null, $accountNumber = null)
    {
        $this
            ->setBillingCode($billingCode)
            ->setResGuestRPH($resGuestRPH)
            ->setBillingType($billingType)
            ->setAuthorizationCode($authorizationCode)
            ->setDescription($description)
            ->setAccountNumber($accountNumber);
    }
    /**
     * Get BillingCode value
     * @return string
     */
    public function getBillingCode()
    {
        return $this->BillingCode;
    }
    /**
     * Set BillingCode value
     * @param string $billingCode
     * @return \StructType\BillingInstructionCode
     */
    public function setBillingCode($billingCode = null)
    {
        // validation for constraint: string
        if (!is_null($billingCode) && !is_string($billingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingCode, true), gettype($billingCode)), __LINE__);
        }
        $this->BillingCode = $billingCode;
        return $this;
    }
    /**
     * Get ResGuestRPH value
     * @return \StructType\ResGuestRPH[]|null
     */
    public function getResGuestRPH()
    {
        return $this->ResGuestRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setResGuestRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResGuestRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResGuestRPHForArrayConstraintsFromSetResGuestRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billingInstructionCodeResGuestRPHItem) {
            // validation for constraint: itemType
            if (!$billingInstructionCodeResGuestRPHItem instanceof \StructType\ResGuestRPH) {
                $invalidValues[] = is_object($billingInstructionCodeResGuestRPHItem) ? get_class($billingInstructionCodeResGuestRPHItem) : sprintf('%s(%s)', gettype($billingInstructionCodeResGuestRPHItem), var_export($billingInstructionCodeResGuestRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResGuestRPH property can only contain items of type \StructType\ResGuestRPH, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResGuestRPH value
     * @throws \InvalidArgumentException
     * @param \StructType\ResGuestRPH[] $resGuestRPH
     * @return \StructType\BillingInstructionCode
     */
    public function setResGuestRPH(array $resGuestRPH = array())
    {
        // validation for constraint: array
        if ('' !== ($resGuestRPHArrayErrorMessage = self::validateResGuestRPHForArrayConstraintsFromSetResGuestRPH($resGuestRPH))) {
            throw new \InvalidArgumentException($resGuestRPHArrayErrorMessage, __LINE__);
        }
        $this->ResGuestRPH = $resGuestRPH;
        return $this;
    }
    /**
     * Add item to ResGuestRPH value
     * @throws \InvalidArgumentException
     * @param \StructType\ResGuestRPH $item
     * @return \StructType\BillingInstructionCode
     */
    public function addToResGuestRPH(\StructType\ResGuestRPH $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResGuestRPH) {
            throw new \InvalidArgumentException(sprintf('The ResGuestRPH property can only contain items of type \StructType\ResGuestRPH, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ResGuestRPH[] = $item;
        return $this;
    }
    /**
     * Get BillingType value
     * @return string|null
     */
    public function getBillingType()
    {
        return $this->BillingType;
    }
    /**
     * Set BillingType value
     * @param string $billingType
     * @return \StructType\BillingInstructionCode
     */
    public function setBillingType($billingType = null)
    {
        // validation for constraint: string
        if (!is_null($billingType) && !is_string($billingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingType, true), gettype($billingType)), __LINE__);
        }
        $this->BillingType = $billingType;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\BillingInstructionCode
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\BillingInstructionCode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\BillingInstructionCode
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingInstructionCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
