<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BerthDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines information about a berth sleeper.
 * @subpackage Structs
 */
class BerthDetailType extends \EnumType\BerthAccommodationType
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: The berth number.
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - documentation: The berth position, such as Lower and Middle.
     * - use: optional
     * @var string
     */
    public $Position;
    /**
     * Constructor method for BerthDetailType
     * @uses BerthDetailType::setNumber()
     * @uses BerthDetailType::setPosition()
     * @param string $number
     * @param string $position
     */
    public function __construct($number = null, $position = null)
    {
        $this
            ->setNumber($number)
            ->setPosition($position);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\BerthDetailType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @uses \EnumType\BerthPositionType::valueIsValid()
     * @uses \EnumType\BerthPositionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $position
     * @return \StructType\BerthDetailType
     */
    public function setPosition($position = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BerthPositionType::valueIsValid($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BerthPositionType', is_array($position) ? implode(', ', $position) : var_export($position, true), implode(', ', \EnumType\BerthPositionType::getValidValues())), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BerthDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
