<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicPropertyInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: An abbreviated short summary of hotel descriptive information.
 * @subpackage Structs
 */
class BasicPropertyInfoType extends AbstractStructBase
{
    /**
     * The VendorMessages
     * Meta information extracted from the WSDL
     * - documentation: A collection of VenderMessages.
     * - minOccurs: 0
     * @var mixed
     */
    public $VendorMessages;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Public address of the hotel property.
     * - minOccurs: 0
     * @var mixed
     */
    public $Address;
    /**
     * The ContactNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The Award
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Award[]
     */
    public $Award;
    /**
     * The RelativePosition
     * Meta information extracted from the WSDL
     * - documentation: Describes the location of the property and available to/from transportation methods.
     * - minOccurs: 0
     * @var mixed
     */
    public $RelativePosition;
    /**
     * The HotelAmenity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelAmenity[]
     */
    public $HotelAmenity;
    /**
     * The HotelFeature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelFeature[]
     */
    public $HotelFeature;
    /**
     * The Recreation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recreation[]
     */
    public $Recreation;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Service[]
     */
    public $Service;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Policy
     */
    public $Policy;
    /**
     * The HotelMeetingFacility
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelMeetingFacility[]
     */
    public $HotelMeetingFacility;
    /**
     * The HotelSegmentCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the segment (e.g., luxury, upscale, extended stay) of the hotel. Refer to OpenTravel Codelist Segment Category Code (SEG).
     * - use: optional
     * @var string
     */
    public $HotelSegmentCategoryCode;
    /**
     * The SupplierIntegrationLevel
     * Meta information extracted from the WSDL
     * - documentation: The level of integration of a property to provide automated transaction information. The lower the number, the higher the integration (e.g., a 1 means the supplier has the highest level of integration automation).
     * - use: optional
     * @var int
     */
    public $SupplierIntegrationLevel;
    /**
     * The MaxGroupRoomQuantity
     * Meta information extracted from the WSDL
     * - documentation: Provides the maximum number of rooms that can be booked in a property for a group.
     * - use: optional
     * @var int
     */
    public $MaxGroupRoomQuantity;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The code specifying a monetary unit. Use ISO 4217, three alpha code.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MasterChainCode
     * Meta information extracted from the WSDL
     * - documentation: The code that identifies a hotel chain or management group. The hotel chain code is decided between vendors. This attribute is optional if the hotel is an independent property that can be identified by the HotelCode attribute. Use it
     * in conjunction with the chain code to determine the actual chain code that is used between trading partners.
     * - use: optional
     * @var string
     */
    public $MasterChainCode;
    /**
     * Constructor method for BasicPropertyInfoType
     * @uses BasicPropertyInfoType::setVendorMessages()
     * @uses BasicPropertyInfoType::setPosition()
     * @uses BasicPropertyInfoType::setAddress()
     * @uses BasicPropertyInfoType::setContactNumbers()
     * @uses BasicPropertyInfoType::setAward()
     * @uses BasicPropertyInfoType::setRelativePosition()
     * @uses BasicPropertyInfoType::setHotelAmenity()
     * @uses BasicPropertyInfoType::setHotelFeature()
     * @uses BasicPropertyInfoType::setRecreation()
     * @uses BasicPropertyInfoType::setService()
     * @uses BasicPropertyInfoType::setPolicy()
     * @uses BasicPropertyInfoType::setHotelMeetingFacility()
     * @uses BasicPropertyInfoType::setHotelSegmentCategoryCode()
     * @uses BasicPropertyInfoType::setSupplierIntegrationLevel()
     * @uses BasicPropertyInfoType::setMaxGroupRoomQuantity()
     * @uses BasicPropertyInfoType::setCurrencyCode()
     * @uses BasicPropertyInfoType::setMasterChainCode()
     * @param mixed $vendorMessages
     * @param \StructType\Position $position
     * @param mixed $address
     * @param \StructType\ContactNumbers $contactNumbers
     * @param \StructType\Award[] $award
     * @param mixed $relativePosition
     * @param \StructType\HotelAmenity[] $hotelAmenity
     * @param \StructType\HotelFeature[] $hotelFeature
     * @param \StructType\Recreation[] $recreation
     * @param \StructType\Service[] $service
     * @param \StructType\Policy $policy
     * @param \StructType\HotelMeetingFacility[] $hotelMeetingFacility
     * @param string $hotelSegmentCategoryCode
     * @param int $supplierIntegrationLevel
     * @param int $maxGroupRoomQuantity
     * @param string $currencyCode
     * @param string $masterChainCode
     */
    public function __construct($vendorMessages = null, \StructType\Position $position = null, $address = null, \StructType\ContactNumbers $contactNumbers = null, array $award = array(), $relativePosition = null, array $hotelAmenity = array(), array $hotelFeature = array(), array $recreation = array(), array $service = array(), \StructType\Policy $policy = null, array $hotelMeetingFacility = array(), $hotelSegmentCategoryCode = null, $supplierIntegrationLevel = null, $maxGroupRoomQuantity = null, $currencyCode = null, $masterChainCode = null)
    {
        $this
            ->setVendorMessages($vendorMessages)
            ->setPosition($position)
            ->setAddress($address)
            ->setContactNumbers($contactNumbers)
            ->setAward($award)
            ->setRelativePosition($relativePosition)
            ->setHotelAmenity($hotelAmenity)
            ->setHotelFeature($hotelFeature)
            ->setRecreation($recreation)
            ->setService($service)
            ->setPolicy($policy)
            ->setHotelMeetingFacility($hotelMeetingFacility)
            ->setHotelSegmentCategoryCode($hotelSegmentCategoryCode)
            ->setSupplierIntegrationLevel($supplierIntegrationLevel)
            ->setMaxGroupRoomQuantity($maxGroupRoomQuantity)
            ->setCurrencyCode($currencyCode)
            ->setMasterChainCode($masterChainCode);
    }
    /**
     * Get VendorMessages value
     * @return mixed|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param mixed $vendorMessages
     * @return \StructType\BasicPropertyInfoType
     */
    public function setVendorMessages($vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\BasicPropertyInfoType
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return mixed|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param mixed $address
     * @return \StructType\BasicPropertyInfoType
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \StructType\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \StructType\ContactNumbers $contactNumbers
     * @return \StructType\BasicPropertyInfoType
     */
    public function setContactNumbers(\StructType\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get Award value
     * @return \StructType\Award[]|null
     */
    public function getAward()
    {
        return $this->Award;
    }
    /**
     * This method is responsible for validating the values passed to the setAward method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAward method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAwardForArrayConstraintsFromSetAward(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeAwardItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeAwardItem instanceof \StructType\Award) {
                $invalidValues[] = is_object($basicPropertyInfoTypeAwardItem) ? get_class($basicPropertyInfoTypeAwardItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeAwardItem), var_export($basicPropertyInfoTypeAwardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award[] $award
     * @return \StructType\BasicPropertyInfoType
     */
    public function setAward(array $award = array())
    {
        // validation for constraint: array
        if ('' !== ($awardArrayErrorMessage = self::validateAwardForArrayConstraintsFromSetAward($award))) {
            throw new \InvalidArgumentException($awardArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($award) && count($award) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($award)), __LINE__);
        }
        $this->Award = $award;
        return $this;
    }
    /**
     * Add item to Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToAward(\StructType\Award $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Award) {
            throw new \InvalidArgumentException(sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Award) && count($this->Award) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Award)), __LINE__);
        }
        $this->Award[] = $item;
        return $this;
    }
    /**
     * Get RelativePosition value
     * @return mixed|null
     */
    public function getRelativePosition()
    {
        return $this->RelativePosition;
    }
    /**
     * Set RelativePosition value
     * @param mixed $relativePosition
     * @return \StructType\BasicPropertyInfoType
     */
    public function setRelativePosition($relativePosition = null)
    {
        $this->RelativePosition = $relativePosition;
        return $this;
    }
    /**
     * Get HotelAmenity value
     * @return \StructType\HotelAmenity[]|null
     */
    public function getHotelAmenity()
    {
        return $this->HotelAmenity;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelAmenityForArrayConstraintsFromSetHotelAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeHotelAmenityItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeHotelAmenityItem instanceof \StructType\HotelAmenity) {
                $invalidValues[] = is_object($basicPropertyInfoTypeHotelAmenityItem) ? get_class($basicPropertyInfoTypeHotelAmenityItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeHotelAmenityItem), var_export($basicPropertyInfoTypeHotelAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelAmenity property can only contain items of type \StructType\HotelAmenity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelAmenity[] $hotelAmenity
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelAmenity(array $hotelAmenity = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelAmenityArrayErrorMessage = self::validateHotelAmenityForArrayConstraintsFromSetHotelAmenity($hotelAmenity))) {
            throw new \InvalidArgumentException($hotelAmenityArrayErrorMessage, __LINE__);
        }
        $this->HotelAmenity = $hotelAmenity;
        return $this;
    }
    /**
     * Add item to HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelAmenity $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToHotelAmenity(\StructType\HotelAmenity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelAmenity) {
            throw new \InvalidArgumentException(sprintf('The HotelAmenity property can only contain items of type \StructType\HotelAmenity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelAmenity[] = $item;
        return $this;
    }
    /**
     * Get HotelFeature value
     * @return \StructType\HotelFeature[]|null
     */
    public function getHotelFeature()
    {
        return $this->HotelFeature;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelFeature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelFeature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelFeatureForArrayConstraintsFromSetHotelFeature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeHotelFeatureItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeHotelFeatureItem instanceof \StructType\HotelFeature) {
                $invalidValues[] = is_object($basicPropertyInfoTypeHotelFeatureItem) ? get_class($basicPropertyInfoTypeHotelFeatureItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeHotelFeatureItem), var_export($basicPropertyInfoTypeHotelFeatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelFeature property can only contain items of type \StructType\HotelFeature, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelFeature[] $hotelFeature
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelFeature(array $hotelFeature = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelFeatureArrayErrorMessage = self::validateHotelFeatureForArrayConstraintsFromSetHotelFeature($hotelFeature))) {
            throw new \InvalidArgumentException($hotelFeatureArrayErrorMessage, __LINE__);
        }
        $this->HotelFeature = $hotelFeature;
        return $this;
    }
    /**
     * Add item to HotelFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelFeature $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToHotelFeature(\StructType\HotelFeature $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelFeature) {
            throw new \InvalidArgumentException(sprintf('The HotelFeature property can only contain items of type \StructType\HotelFeature, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelFeature[] = $item;
        return $this;
    }
    /**
     * Get Recreation value
     * @return \StructType\Recreation[]|null
     */
    public function getRecreation()
    {
        return $this->Recreation;
    }
    /**
     * This method is responsible for validating the values passed to the setRecreation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecreation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecreationForArrayConstraintsFromSetRecreation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeRecreationItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeRecreationItem instanceof \StructType\Recreation) {
                $invalidValues[] = is_object($basicPropertyInfoTypeRecreationItem) ? get_class($basicPropertyInfoTypeRecreationItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeRecreationItem), var_export($basicPropertyInfoTypeRecreationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recreation property can only contain items of type \StructType\Recreation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recreation value
     * @throws \InvalidArgumentException
     * @param \StructType\Recreation[] $recreation
     * @return \StructType\BasicPropertyInfoType
     */
    public function setRecreation(array $recreation = array())
    {
        // validation for constraint: array
        if ('' !== ($recreationArrayErrorMessage = self::validateRecreationForArrayConstraintsFromSetRecreation($recreation))) {
            throw new \InvalidArgumentException($recreationArrayErrorMessage, __LINE__);
        }
        $this->Recreation = $recreation;
        return $this;
    }
    /**
     * Add item to Recreation value
     * @throws \InvalidArgumentException
     * @param \StructType\Recreation $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToRecreation(\StructType\Recreation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recreation) {
            throw new \InvalidArgumentException(sprintf('The Recreation property can only contain items of type \StructType\Recreation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recreation[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\Service[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeServiceItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeServiceItem instanceof \StructType\Service) {
                $invalidValues[] = is_object($basicPropertyInfoTypeServiceItem) ? get_class($basicPropertyInfoTypeServiceItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeServiceItem), var_export($basicPropertyInfoTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service[] $service
     * @return \StructType\BasicPropertyInfoType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToService(\StructType\Service $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Service) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get Policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * Set Policy value
     * @param \StructType\Policy $policy
     * @return \StructType\BasicPropertyInfoType
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Get HotelMeetingFacility value
     * @return \StructType\HotelMeetingFacility[]|null
     */
    public function getHotelMeetingFacility()
    {
        return $this->HotelMeetingFacility;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelMeetingFacility method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelMeetingFacility method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelMeetingFacilityForArrayConstraintsFromSetHotelMeetingFacility(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeHotelMeetingFacilityItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeHotelMeetingFacilityItem instanceof \StructType\HotelMeetingFacility) {
                $invalidValues[] = is_object($basicPropertyInfoTypeHotelMeetingFacilityItem) ? get_class($basicPropertyInfoTypeHotelMeetingFacilityItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeHotelMeetingFacilityItem), var_export($basicPropertyInfoTypeHotelMeetingFacilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelMeetingFacility property can only contain items of type \StructType\HotelMeetingFacility, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelMeetingFacility value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelMeetingFacility[] $hotelMeetingFacility
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelMeetingFacility(array $hotelMeetingFacility = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelMeetingFacilityArrayErrorMessage = self::validateHotelMeetingFacilityForArrayConstraintsFromSetHotelMeetingFacility($hotelMeetingFacility))) {
            throw new \InvalidArgumentException($hotelMeetingFacilityArrayErrorMessage, __LINE__);
        }
        $this->HotelMeetingFacility = $hotelMeetingFacility;
        return $this;
    }
    /**
     * Add item to HotelMeetingFacility value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelMeetingFacility $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToHotelMeetingFacility(\StructType\HotelMeetingFacility $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelMeetingFacility) {
            throw new \InvalidArgumentException(sprintf('The HotelMeetingFacility property can only contain items of type \StructType\HotelMeetingFacility, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelMeetingFacility[] = $item;
        return $this;
    }
    /**
     * Get HotelSegmentCategoryCode value
     * @return string|null
     */
    public function getHotelSegmentCategoryCode()
    {
        return $this->HotelSegmentCategoryCode;
    }
    /**
     * Set HotelSegmentCategoryCode value
     * @param string $hotelSegmentCategoryCode
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelSegmentCategoryCode($hotelSegmentCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelSegmentCategoryCode) && !is_string($hotelSegmentCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelSegmentCategoryCode, true), gettype($hotelSegmentCategoryCode)), __LINE__);
        }
        $this->HotelSegmentCategoryCode = $hotelSegmentCategoryCode;
        return $this;
    }
    /**
     * Get SupplierIntegrationLevel value
     * @return int|null
     */
    public function getSupplierIntegrationLevel()
    {
        return $this->SupplierIntegrationLevel;
    }
    /**
     * Set SupplierIntegrationLevel value
     * @param int $supplierIntegrationLevel
     * @return \StructType\BasicPropertyInfoType
     */
    public function setSupplierIntegrationLevel($supplierIntegrationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($supplierIntegrationLevel) && !(is_int($supplierIntegrationLevel) || ctype_digit($supplierIntegrationLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supplierIntegrationLevel, true), gettype($supplierIntegrationLevel)), __LINE__);
        }
        $this->SupplierIntegrationLevel = $supplierIntegrationLevel;
        return $this;
    }
    /**
     * Get MaxGroupRoomQuantity value
     * @return int|null
     */
    public function getMaxGroupRoomQuantity()
    {
        return $this->MaxGroupRoomQuantity;
    }
    /**
     * Set MaxGroupRoomQuantity value
     * @param int $maxGroupRoomQuantity
     * @return \StructType\BasicPropertyInfoType
     */
    public function setMaxGroupRoomQuantity($maxGroupRoomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxGroupRoomQuantity) && !(is_int($maxGroupRoomQuantity) || ctype_digit($maxGroupRoomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxGroupRoomQuantity, true), gettype($maxGroupRoomQuantity)), __LINE__);
        }
        $this->MaxGroupRoomQuantity = $maxGroupRoomQuantity;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\BasicPropertyInfoType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MasterChainCode value
     * @return string|null
     */
    public function getMasterChainCode()
    {
        return $this->MasterChainCode;
    }
    /**
     * Set MasterChainCode value
     * @param string $masterChainCode
     * @return \StructType\BasicPropertyInfoType
     */
    public function setMasterChainCode($masterChainCode = null)
    {
        // validation for constraint: string
        if (!is_null($masterChainCode) && !is_string($masterChainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterChainCode, true), gettype($masterChainCode)), __LINE__);
        }
        $this->MasterChainCode = $masterChainCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BasicPropertyInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
