<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicFare StructType
 * Meta information extracted from the WSDL
 * - documentation: A fare basis code and associated fare amount.
 * @subpackage Structs
 */
class BasicFare extends AbstractStructBase
{
    /**
     * The AlternateCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\AlternateCurrency[]
     */
    public $AlternateCurrency;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: A fare basis code.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * Constructor method for BasicFare
     * @uses BasicFare::setAlternateCurrency()
     * @uses BasicFare::setFareBasisCode()
     * @param \StructType\AlternateCurrency[] $alternateCurrency
     * @param string $fareBasisCode
     */
    public function __construct(array $alternateCurrency = array(), $fareBasisCode = null)
    {
        $this
            ->setAlternateCurrency($alternateCurrency)
            ->setFareBasisCode($fareBasisCode);
    }
    /**
     * Get AlternateCurrency value
     * @return \StructType\AlternateCurrency[]|null
     */
    public function getAlternateCurrency()
    {
        return $this->AlternateCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternateCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternateCurrencyForArrayConstraintsFromSetAlternateCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicFareAlternateCurrencyItem) {
            // validation for constraint: itemType
            if (!$basicFareAlternateCurrencyItem instanceof \StructType\AlternateCurrency) {
                $invalidValues[] = is_object($basicFareAlternateCurrencyItem) ? get_class($basicFareAlternateCurrencyItem) : sprintf('%s(%s)', gettype($basicFareAlternateCurrencyItem), var_export($basicFareAlternateCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlternateCurrency property can only contain items of type \StructType\AlternateCurrency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlternateCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\AlternateCurrency[] $alternateCurrency
     * @return \StructType\BasicFare
     */
    public function setAlternateCurrency(array $alternateCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($alternateCurrencyArrayErrorMessage = self::validateAlternateCurrencyForArrayConstraintsFromSetAlternateCurrency($alternateCurrency))) {
            throw new \InvalidArgumentException($alternateCurrencyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($alternateCurrency) && count($alternateCurrency) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($alternateCurrency)), __LINE__);
        }
        $this->AlternateCurrency = $alternateCurrency;
        return $this;
    }
    /**
     * Add item to AlternateCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\AlternateCurrency $item
     * @return \StructType\BasicFare
     */
    public function addToAlternateCurrency(\StructType\AlternateCurrency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AlternateCurrency) {
            throw new \InvalidArgumentException(sprintf('The AlternateCurrency property can only contain items of type \StructType\AlternateCurrency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->AlternateCurrency) && count($this->AlternateCurrency) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->AlternateCurrency)), __LINE__);
        }
        $this->AlternateCurrency[] = $item;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\BasicFare
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BasicFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
