<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseByGuestAmt StructType
 * Meta information extracted from the WSDL
 * - documentation: Base charge for a given number of guests for a given age qualifying code.
 * @subpackage Structs
 */
class BaseByGuestAmt extends TotalType
{
    /**
     * The NumberOfGuestsDescription
     * Meta information extracted from the WSDL
     * - documentation: Description of number of guests and the associated age group (ex 2 Adults).
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $NumberOfGuestsDescription;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: The code associated with this base charge.
     * @var string
     */
    public $Code;
    /**
     * The NumberOfGuests
     * Meta information extracted from the WSDL
     * - documentation: The number of guests associated with this base charge.
     * - use: optional
     * @var int
     */
    public $NumberOfGuests;
    /**
     * Constructor method for BaseByGuestAmt
     * @uses BaseByGuestAmt::setNumberOfGuestsDescription()
     * @uses BaseByGuestAmt::setCode()
     * @uses BaseByGuestAmt::setNumberOfGuests()
     * @param mixed[] $numberOfGuestsDescription
     * @param string $code
     * @param int $numberOfGuests
     */
    public function __construct(array $numberOfGuestsDescription = array(), $code = null, $numberOfGuests = null)
    {
        $this
            ->setNumberOfGuestsDescription($numberOfGuestsDescription)
            ->setCode($code)
            ->setNumberOfGuests($numberOfGuests);
    }
    /**
     * Get NumberOfGuestsDescription value
     * @return mixed[]|null
     */
    public function getNumberOfGuestsDescription()
    {
        return $this->NumberOfGuestsDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setNumberOfGuestsDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumberOfGuestsDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNumberOfGuestsDescriptionForArrayConstraintsFromSetNumberOfGuestsDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baseByGuestAmtNumberOfGuestsDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($baseByGuestAmtNumberOfGuestsDescriptionItem) ? get_class($baseByGuestAmtNumberOfGuestsDescriptionItem) : sprintf('%s(%s)', gettype($baseByGuestAmtNumberOfGuestsDescriptionItem), var_export($baseByGuestAmtNumberOfGuestsDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NumberOfGuestsDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NumberOfGuestsDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $numberOfGuestsDescription
     * @return \StructType\BaseByGuestAmt
     */
    public function setNumberOfGuestsDescription(array $numberOfGuestsDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($numberOfGuestsDescriptionArrayErrorMessage = self::validateNumberOfGuestsDescriptionForArrayConstraintsFromSetNumberOfGuestsDescription($numberOfGuestsDescription))) {
            throw new \InvalidArgumentException($numberOfGuestsDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($numberOfGuestsDescription) && count($numberOfGuestsDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($numberOfGuestsDescription)), __LINE__);
        }
        $this->NumberOfGuestsDescription = $numberOfGuestsDescription;
        return $this;
    }
    /**
     * Add item to NumberOfGuestsDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\BaseByGuestAmt
     */
    public function addToNumberOfGuestsDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The NumberOfGuestsDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->NumberOfGuestsDescription) && count($this->NumberOfGuestsDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->NumberOfGuestsDescription)), __LINE__);
        }
        $this->NumberOfGuestsDescription[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\BaseByGuestAmt
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get NumberOfGuests value
     * @return int|null
     */
    public function getNumberOfGuests()
    {
        return $this->NumberOfGuests;
    }
    /**
     * Set NumberOfGuests value
     * @param int $numberOfGuests
     * @return \StructType\BaseByGuestAmt
     */
    public function setNumberOfGuests($numberOfGuests = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGuests) && !(is_int($numberOfGuests) || ctype_digit($numberOfGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGuests, true), gettype($numberOfGuests)), __LINE__);
        }
        $this->NumberOfGuests = $numberOfGuests;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseByGuestAmt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
