<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAcctType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data use and sharing permissions. | Customer bank account definition.
 * @subpackage Structs
 */
class BankAcctType extends AbstractStructBase
{
    /**
     * The BankAcctName
     * Meta information extracted from the WSDL
     * - documentation: Example: Joseph L Smith | Account holder name.
     * - minOccurs: 0
     * @var mixed
     */
    public $BankAcctName;
    /**
     * The BankAcctNumber
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Best Practice: Bank Account Payment Instruction Tokens: Some OpenTravel schema may contain combinations of elements and attributes that have bank account number and other personally identifying information within the
     * schema, such as customer name and date of birth. For enhanced customer privacy and security, it is RECOMMENDED that the bank account number and ID be encrypted, using tokenization or some other method. | Account number.
     * - minOccurs: 0
     * @var mixed
     */
    public $BankAcctNumber;
    /**
     * The BankID
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Best Practice: Bank Account Payment Instruction Tokens: Some OpenTravel schema may contain combinations of elements and attributes that have bank account number and other personally identifying information within the
     * schema, such as customer name and date of birth. For enhanced customer privacy and security, it is RECOMMENDED that the bank account number and ID be encrypted, using tokenization or some other method. | Bank ID or routing number.
     * - minOccurs: 0
     * @var mixed
     */
    public $BankID;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Example: Checking | Bank account type.
     * - minOccurs: 0
     * @var mixed
     */
    public $Type;
    /**
     * The ChecksAcceptedInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, checks are accepted. | Example: true | Checks accepted indicator.
     * - use: optional
     * @var bool
     */
    public $ChecksAcceptedInd;
    /**
     * The CheckNumber
     * Meta information extracted from the WSDL
     * - documentation: Example: 999 | Check number.
     * - use: optional
     * @var string
     */
    public $CheckNumber;
    /**
     * Constructor method for BankAcctType
     * @uses BankAcctType::setBankAcctName()
     * @uses BankAcctType::setBankAcctNumber()
     * @uses BankAcctType::setBankID()
     * @uses BankAcctType::setType()
     * @uses BankAcctType::setChecksAcceptedInd()
     * @uses BankAcctType::setCheckNumber()
     * @param mixed $bankAcctName
     * @param mixed $bankAcctNumber
     * @param mixed $bankID
     * @param mixed $type
     * @param bool $checksAcceptedInd
     * @param string $checkNumber
     */
    public function __construct($bankAcctName = null, $bankAcctNumber = null, $bankID = null, $type = null, $checksAcceptedInd = null, $checkNumber = null)
    {
        $this
            ->setBankAcctName($bankAcctName)
            ->setBankAcctNumber($bankAcctNumber)
            ->setBankID($bankID)
            ->setType($type)
            ->setChecksAcceptedInd($checksAcceptedInd)
            ->setCheckNumber($checkNumber);
    }
    /**
     * Get BankAcctName value
     * @return mixed|null
     */
    public function getBankAcctName()
    {
        return $this->BankAcctName;
    }
    /**
     * Set BankAcctName value
     * @param mixed $bankAcctName
     * @return \StructType\BankAcctType
     */
    public function setBankAcctName($bankAcctName = null)
    {
        $this->BankAcctName = $bankAcctName;
        return $this;
    }
    /**
     * Get BankAcctNumber value
     * @return mixed|null
     */
    public function getBankAcctNumber()
    {
        return $this->BankAcctNumber;
    }
    /**
     * Set BankAcctNumber value
     * @param mixed $bankAcctNumber
     * @return \StructType\BankAcctType
     */
    public function setBankAcctNumber($bankAcctNumber = null)
    {
        $this->BankAcctNumber = $bankAcctNumber;
        return $this;
    }
    /**
     * Get BankID value
     * @return mixed|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param mixed $bankID
     * @return \StructType\BankAcctType
     */
    public function setBankID($bankID = null)
    {
        $this->BankID = $bankID;
        return $this;
    }
    /**
     * Get Type value
     * @return mixed|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param mixed $type
     * @return \StructType\BankAcctType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ChecksAcceptedInd value
     * @return bool|null
     */
    public function getChecksAcceptedInd()
    {
        return $this->ChecksAcceptedInd;
    }
    /**
     * Set ChecksAcceptedInd value
     * @param bool $checksAcceptedInd
     * @return \StructType\BankAcctType
     */
    public function setChecksAcceptedInd($checksAcceptedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($checksAcceptedInd) && !is_bool($checksAcceptedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checksAcceptedInd, true), gettype($checksAcceptedInd)), __LINE__);
        }
        $this->ChecksAcceptedInd = $checksAcceptedInd;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \StructType\BankAcctType
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAcctType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
