<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageWeightType StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage weight specification.
 * @subpackage Structs
 */
class BaggageWeightType extends List_UnitOfMeasure
{
    /**
     * The ApproxInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the baggage weight is approximate.
     * - use: optional
     * @var bool
     */
    public $ApproxInd;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - documentation: Example: 57.35 | Baggage weight.
     * - use: optional
     * @var float
     */
    public $Weight;
    /**
     * Constructor method for BaggageWeightType
     * @uses BaggageWeightType::setApproxInd()
     * @uses BaggageWeightType::setWeight()
     * @param bool $approxInd
     * @param float $weight
     */
    public function __construct($approxInd = null, $weight = null)
    {
        $this
            ->setApproxInd($approxInd)
            ->setWeight($weight);
    }
    /**
     * Get ApproxInd value
     * @return bool|null
     */
    public function getApproxInd()
    {
        return $this->ApproxInd;
    }
    /**
     * Set ApproxInd value
     * @param bool $approxInd
     * @return \StructType\BaggageWeightType
     */
    public function setApproxInd($approxInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($approxInd) && !is_bool($approxInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approxInd, true), gettype($approxInd)), __LINE__);
        }
        $this->ApproxInd = $approxInd;
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\BaggageWeightType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaggageWeightType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
