<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageSizeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage size specification.
 * @subpackage Structs
 */
class BaggageSizeType extends List_UnitOfMeasure
{
    /**
     * The ApproxInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the baggage dimensions are approximate.
     * - use: optional
     * @var bool
     */
    public $ApproxInd;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: Example: 13.5 | Baggage height.
     * - use: optional
     * @var float
     */
    public $Height;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - documentation: Example: 33 | Baggage length.
     * - use: optional
     * @var float
     */
    public $Length;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: Example: 16.25 | Baggage width.
     * - use: optional
     * @var float
     */
    public $Width;
    /**
     * The LinearDimensions
     * Meta information extracted from the WSDL
     * - documentation: Example: 62.75 | Note: This is the total linear measurement of the baggage (Length + Height + Width). | Linear dimensions.
     * - use: optional
     * @var string
     */
    public $LinearDimensions;
    /**
     * Constructor method for BaggageSizeType
     * @uses BaggageSizeType::setApproxInd()
     * @uses BaggageSizeType::setHeight()
     * @uses BaggageSizeType::setLength()
     * @uses BaggageSizeType::setWidth()
     * @uses BaggageSizeType::setLinearDimensions()
     * @param bool $approxInd
     * @param float $height
     * @param float $length
     * @param float $width
     * @param string $linearDimensions
     */
    public function __construct($approxInd = null, $height = null, $length = null, $width = null, $linearDimensions = null)
    {
        $this
            ->setApproxInd($approxInd)
            ->setHeight($height)
            ->setLength($length)
            ->setWidth($width)
            ->setLinearDimensions($linearDimensions);
    }
    /**
     * Get ApproxInd value
     * @return bool|null
     */
    public function getApproxInd()
    {
        return $this->ApproxInd;
    }
    /**
     * Set ApproxInd value
     * @param bool $approxInd
     * @return \StructType\BaggageSizeType
     */
    public function setApproxInd($approxInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($approxInd) && !is_bool($approxInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approxInd, true), gettype($approxInd)), __LINE__);
        }
        $this->ApproxInd = $approxInd;
        return $this;
    }
    /**
     * Get Height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \StructType\BaggageSizeType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \StructType\BaggageSizeType
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \StructType\BaggageSizeType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get LinearDimensions value
     * @return string|null
     */
    public function getLinearDimensions()
    {
        return $this->LinearDimensions;
    }
    /**
     * Set LinearDimensions value
     * @param string $linearDimensions
     * @return \StructType\BaggageSizeType
     */
    public function setLinearDimensions($linearDimensions = null)
    {
        // validation for constraint: string
        if (!is_null($linearDimensions) && !is_string($linearDimensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linearDimensions, true), gettype($linearDimensions)), __LINE__);
        }
        $this->LinearDimensions = $linearDimensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaggageSizeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
