<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageQueryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about baggage associated with a traveler for allowing the offer engine to determine baggage services.
 * @subpackage Structs
 */
class BaggageQueryType extends AbstractStructBase
{
    /**
     * The AirlineCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AirlineCarrier
     */
    public $AirlineCarrier;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The OriginCityCode
     * Meta information extracted from the WSDL
     * - documentation: The baggage origin airport city code.
     * - use: optional
     * @var string
     */
    public $OriginCityCode;
    /**
     * The OriginCodeContext
     * Meta information extracted from the WSDL
     * - documentation: Identifies the context of the baggage origin city code such as IATA, ARC, or internal code.
     * - use: optional
     * @var string
     */
    public $OriginCodeContext;
    /**
     * The DestinationCityCode
     * Meta information extracted from the WSDL
     * - documentation: The baggage destination airport city code.
     * - use: optional
     * @var string
     */
    public $DestinationCityCode;
    /**
     * The DestinationCodeContext
     * Meta information extracted from the WSDL
     * - documentation: Identifies the context of the baggage destination city code such as IATA, ARC, or internal code.
     * - use: optional
     * @var string
     */
    public $DestinationCodeContext;
    /**
     * The TravelerRPH
     * Meta information extracted from the WSDL
     * - documentation: (Developer Notes) RPH value set in:OTA_AirGetOfferRQ/RequestCriterion/PreBookingInfo/TravelerInfo/AirTraveler/@RPH | A reference to a traveler RPH defined elsewhere in this message.
     * - use: optional
     * @var string
     */
    public $TravelerRPH;
    /**
     * The ItinerarySegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: (Developer Notes) The corresponding value for this RPH is set
     * here:OTA_AirGetOfferRQ/RequestCriterion/PreBookingInfo/AirItineraryInfo/PricedAirItinerary/PricedItinerary/AirItinerary/OriginDestinationOptions/OriginDestinationOption/FlightSegment/@RPH | A unique identifier for a flight segment within an O/D
     * priced option. Only use this if you intend to price an item by flight segments.
     * - use: optional
     * @var string
     */
    public $ItinerarySegmentRPH;
    /**
     * Constructor method for BaggageQueryType
     * @uses BaggageQueryType::setAirlineCarrier()
     * @uses BaggageQueryType::setCode()
     * @uses BaggageQueryType::setOriginCityCode()
     * @uses BaggageQueryType::setOriginCodeContext()
     * @uses BaggageQueryType::setDestinationCityCode()
     * @uses BaggageQueryType::setDestinationCodeContext()
     * @uses BaggageQueryType::setTravelerRPH()
     * @uses BaggageQueryType::setItinerarySegmentRPH()
     * @param \StructType\AirlineCarrier $airlineCarrier
     * @param string $code
     * @param string $originCityCode
     * @param string $originCodeContext
     * @param string $destinationCityCode
     * @param string $destinationCodeContext
     * @param string $travelerRPH
     * @param string $itinerarySegmentRPH
     */
    public function __construct(\StructType\AirlineCarrier $airlineCarrier = null, $code = null, $originCityCode = null, $originCodeContext = null, $destinationCityCode = null, $destinationCodeContext = null, $travelerRPH = null, $itinerarySegmentRPH = null)
    {
        $this
            ->setAirlineCarrier($airlineCarrier)
            ->setCode($code)
            ->setOriginCityCode($originCityCode)
            ->setOriginCodeContext($originCodeContext)
            ->setDestinationCityCode($destinationCityCode)
            ->setDestinationCodeContext($destinationCodeContext)
            ->setTravelerRPH($travelerRPH)
            ->setItinerarySegmentRPH($itinerarySegmentRPH);
    }
    /**
     * Get AirlineCarrier value
     * @return \StructType\AirlineCarrier|null
     */
    public function getAirlineCarrier()
    {
        return $this->AirlineCarrier;
    }
    /**
     * Set AirlineCarrier value
     * @param \StructType\AirlineCarrier $airlineCarrier
     * @return \StructType\BaggageQueryType
     */
    public function setAirlineCarrier(\StructType\AirlineCarrier $airlineCarrier = null)
    {
        $this->AirlineCarrier = $airlineCarrier;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\BaggageQueryType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OriginCityCode value
     * @return string|null
     */
    public function getOriginCityCode()
    {
        return $this->OriginCityCode;
    }
    /**
     * Set OriginCityCode value
     * @param string $originCityCode
     * @return \StructType\BaggageQueryType
     */
    public function setOriginCityCode($originCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCityCode) && !is_string($originCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCityCode, true), gettype($originCityCode)), __LINE__);
        }
        $this->OriginCityCode = $originCityCode;
        return $this;
    }
    /**
     * Get OriginCodeContext value
     * @return string|null
     */
    public function getOriginCodeContext()
    {
        return $this->OriginCodeContext;
    }
    /**
     * Set OriginCodeContext value
     * @param string $originCodeContext
     * @return \StructType\BaggageQueryType
     */
    public function setOriginCodeContext($originCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($originCodeContext) && !is_string($originCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCodeContext, true), gettype($originCodeContext)), __LINE__);
        }
        $this->OriginCodeContext = $originCodeContext;
        return $this;
    }
    /**
     * Get DestinationCityCode value
     * @return string|null
     */
    public function getDestinationCityCode()
    {
        return $this->DestinationCityCode;
    }
    /**
     * Set DestinationCityCode value
     * @param string $destinationCityCode
     * @return \StructType\BaggageQueryType
     */
    public function setDestinationCityCode($destinationCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCityCode) && !is_string($destinationCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCityCode, true), gettype($destinationCityCode)), __LINE__);
        }
        $this->DestinationCityCode = $destinationCityCode;
        return $this;
    }
    /**
     * Get DestinationCodeContext value
     * @return string|null
     */
    public function getDestinationCodeContext()
    {
        return $this->DestinationCodeContext;
    }
    /**
     * Set DestinationCodeContext value
     * @param string $destinationCodeContext
     * @return \StructType\BaggageQueryType
     */
    public function setDestinationCodeContext($destinationCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCodeContext) && !is_string($destinationCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCodeContext, true), gettype($destinationCodeContext)), __LINE__);
        }
        $this->DestinationCodeContext = $destinationCodeContext;
        return $this;
    }
    /**
     * Get TravelerRPH value
     * @return string|null
     */
    public function getTravelerRPH()
    {
        return $this->TravelerRPH;
    }
    /**
     * Set TravelerRPH value
     * @param string $travelerRPH
     * @return \StructType\BaggageQueryType
     */
    public function setTravelerRPH($travelerRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRPH) && !is_string($travelerRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerRPH, true), gettype($travelerRPH)), __LINE__);
        }
        $this->TravelerRPH = $travelerRPH;
        return $this;
    }
    /**
     * Get ItinerarySegmentRPH value
     * @return string|null
     */
    public function getItinerarySegmentRPH()
    {
        return $this->ItinerarySegmentRPH;
    }
    /**
     * Set ItinerarySegmentRPH value
     * @param string $itinerarySegmentRPH
     * @return \StructType\BaggageQueryType
     */
    public function setItinerarySegmentRPH($itinerarySegmentRPH = null)
    {
        // validation for constraint: string
        if (!is_null($itinerarySegmentRPH) && !is_string($itinerarySegmentRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itinerarySegmentRPH, true), gettype($itinerarySegmentRPH)), __LINE__);
        }
        $this->ItinerarySegmentRPH = $itinerarySegmentRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaggageQueryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
