<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableSeats StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of seat availability by class.
 * @subpackage Structs
 */
class AvailableSeats extends AbstractStructBase
{
    /**
     * The SeatAvailability
     * Meta information extracted from the WSDL
     * - maxOccurs: 26
     * @var mixed[]
     */
    public $SeatAvailability;
    /**
     * Constructor method for AvailableSeats
     * @uses AvailableSeats::setSeatAvailability()
     * @param mixed[] $seatAvailability
     */
    public function __construct(array $seatAvailability = array())
    {
        $this
            ->setSeatAvailability($seatAvailability);
    }
    /**
     * Get SeatAvailability value
     * @return mixed[]|null
     */
    public function getSeatAvailability()
    {
        return $this->SeatAvailability;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatAvailability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatAvailability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatAvailabilityForArrayConstraintsFromSetSeatAvailability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $availableSeatsSeatAvailabilityItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($availableSeatsSeatAvailabilityItem) ? get_class($availableSeatsSeatAvailabilityItem) : sprintf('%s(%s)', gettype($availableSeatsSeatAvailabilityItem), var_export($availableSeatsSeatAvailabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatAvailability property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatAvailability value
     * @throws \InvalidArgumentException
     * @param mixed[] $seatAvailability
     * @return \StructType\AvailableSeats
     */
    public function setSeatAvailability(array $seatAvailability = array())
    {
        // validation for constraint: array
        if ('' !== ($seatAvailabilityArrayErrorMessage = self::validateSeatAvailabilityForArrayConstraintsFromSetSeatAvailability($seatAvailability))) {
            throw new \InvalidArgumentException($seatAvailabilityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(26)
        if (is_array($seatAvailability) && count($seatAvailability) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 26', count($seatAvailability)), __LINE__);
        }
        $this->SeatAvailability = $seatAvailability;
        return $this;
    }
    /**
     * Add item to SeatAvailability value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AvailableSeats
     */
    public function addToSeatAvailability($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SeatAvailability property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(26)
        if (is_array($this->SeatAvailability) && count($this->SeatAvailability) >= 26) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 26', count($this->SeatAvailability)), __LINE__);
        }
        $this->SeatAvailability[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailableSeats
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
