<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableMealPlans StructType
 * @subpackage Structs
 */
class AvailableMealPlans extends AbstractStructBase
{
    /**
     * The MealPlan
     * Meta information extracted from the WSDL
     * - documentation: Details of meal arrangements, booked or available according to context, with appropriate supplementary charges.
     * - maxOccurs: 9
     * @var mixed[]
     */
    public $MealPlan;
    /**
     * Constructor method for AvailableMealPlans
     * @uses AvailableMealPlans::setMealPlan()
     * @param mixed[] $mealPlan
     */
    public function __construct(array $mealPlan = array())
    {
        $this
            ->setMealPlan($mealPlan);
    }
    /**
     * Get MealPlan value
     * @return mixed[]|null
     */
    public function getMealPlan()
    {
        return $this->MealPlan;
    }
    /**
     * This method is responsible for validating the values passed to the setMealPlan method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMealPlan method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealPlanForArrayConstraintsFromSetMealPlan(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $availableMealPlansMealPlanItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($availableMealPlansMealPlanItem) ? get_class($availableMealPlansMealPlanItem) : sprintf('%s(%s)', gettype($availableMealPlansMealPlanItem), var_export($availableMealPlansMealPlanItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MealPlan property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MealPlan value
     * @throws \InvalidArgumentException
     * @param mixed[] $mealPlan
     * @return \StructType\AvailableMealPlans
     */
    public function setMealPlan(array $mealPlan = array())
    {
        // validation for constraint: array
        if ('' !== ($mealPlanArrayErrorMessage = self::validateMealPlanForArrayConstraintsFromSetMealPlan($mealPlan))) {
            throw new \InvalidArgumentException($mealPlanArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($mealPlan) && count($mealPlan) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($mealPlan)), __LINE__);
        }
        $this->MealPlan = $mealPlan;
        return $this;
    }
    /**
     * Add item to MealPlan value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AvailableMealPlans
     */
    public function addToMealPlan($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MealPlan property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->MealPlan) && count($this->MealPlan) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->MealPlan)), __LINE__);
        }
        $this->MealPlan[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailableMealPlans
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
