<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizedViewers StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for authorized viewers.
 * @subpackage Structs
 */
class AuthorizedViewers extends AbstractStructBase
{
    /**
     * The AuthorizedViewer
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\AuthorizedViewer[]
     */
    public $AuthorizedViewer;
    /**
     * Constructor method for AuthorizedViewers
     * @uses AuthorizedViewers::setAuthorizedViewer()
     * @param \StructType\AuthorizedViewer[] $authorizedViewer
     */
    public function __construct(array $authorizedViewer = array())
    {
        $this
            ->setAuthorizedViewer($authorizedViewer);
    }
    /**
     * Get AuthorizedViewer value
     * @return \StructType\AuthorizedViewer[]|null
     */
    public function getAuthorizedViewer()
    {
        return $this->AuthorizedViewer;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthorizedViewer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorizedViewer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthorizedViewerForArrayConstraintsFromSetAuthorizedViewer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $authorizedViewersAuthorizedViewerItem) {
            // validation for constraint: itemType
            if (!$authorizedViewersAuthorizedViewerItem instanceof \StructType\AuthorizedViewer) {
                $invalidValues[] = is_object($authorizedViewersAuthorizedViewerItem) ? get_class($authorizedViewersAuthorizedViewerItem) : sprintf('%s(%s)', gettype($authorizedViewersAuthorizedViewerItem), var_export($authorizedViewersAuthorizedViewerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AuthorizedViewer property can only contain items of type \StructType\AuthorizedViewer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AuthorizedViewer value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizedViewer[] $authorizedViewer
     * @return \StructType\AuthorizedViewers
     */
    public function setAuthorizedViewer(array $authorizedViewer = array())
    {
        // validation for constraint: array
        if ('' !== ($authorizedViewerArrayErrorMessage = self::validateAuthorizedViewerForArrayConstraintsFromSetAuthorizedViewer($authorizedViewer))) {
            throw new \InvalidArgumentException($authorizedViewerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($authorizedViewer) && count($authorizedViewer) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($authorizedViewer)), __LINE__);
        }
        $this->AuthorizedViewer = $authorizedViewer;
        return $this;
    }
    /**
     * Add item to AuthorizedViewer value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizedViewer $item
     * @return \StructType\AuthorizedViewers
     */
    public function addToAuthorizedViewer(\StructType\AuthorizedViewer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AuthorizedViewer) {
            throw new \InvalidArgumentException(sprintf('The AuthorizedViewer property can only contain items of type \StructType\AuthorizedViewer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AuthorizedViewer) && count($this->AuthorizedViewer) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AuthorizedViewer)), __LINE__);
        }
        $this->AuthorizedViewer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizedViewers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
