<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizationType StructType
 * Meta information extracted from the WSDL
 * - documentation: ToDo - this types should be moved to OTA_CommonTypes. It's required in a common types file, since the both AuthRQ/RS use it. | Information with which a traveller's identification is verified and/or charges are authorized.
 * @subpackage Structs
 */
class AuthorizationType extends AbstractStructBase
{
    /**
     * The CheckAuthorization
     * Meta information extracted from the WSDL
     * - choice: CheckAuthorization | CreditCardAuthorization | AccountAuthorization
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CheckAuthorization
     */
    public $CheckAuthorization;
    /**
     * The CreditCardAuthorization
     * Meta information extracted from the WSDL
     * - choice: CheckAuthorization | CreditCardAuthorization | AccountAuthorization
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CreditCardAuthorization
     */
    public $CreditCardAuthorization;
    /**
     * The AccountAuthorization
     * Meta information extracted from the WSDL
     * - choice: CheckAuthorization | CreditCardAuthorization | AccountAuthorization
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountAuthorization
     */
    public $AccountAuthorization;
    /**
     * The DriversLicenseAuthorization
     * Meta information extracted from the WSDL
     * - documentation: Information used for validating a drivers license or for supporting a check or credit card authorization request.
     * - minOccurs: 0
     * @var mixed
     */
    public $DriversLicenseAuthorization;
    /**
     * The BookingReferenceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingReferenceID
     */
    public $BookingReferenceID;
    /**
     * The PrincipalCompanyCode
     * Meta information extracted from the WSDL
     * - documentation: The code associated with the company (e.g., two to three character airline designator) submitting a request to an authorization vendor system.
     * - use: optional
     * @var string
     */
    public $PrincipalCompanyCode;
    /**
     * The RefNumber
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for an authorization request. It may be used to link a response to a corresponding request item.
     * - use: optional
     * @var string
     */
    public $RefNumber;
    /**
     * Constructor method for AuthorizationType
     * @uses AuthorizationType::setCheckAuthorization()
     * @uses AuthorizationType::setCreditCardAuthorization()
     * @uses AuthorizationType::setAccountAuthorization()
     * @uses AuthorizationType::setDriversLicenseAuthorization()
     * @uses AuthorizationType::setBookingReferenceID()
     * @uses AuthorizationType::setPrincipalCompanyCode()
     * @uses AuthorizationType::setRefNumber()
     * @param \StructType\CheckAuthorization $checkAuthorization
     * @param \StructType\CreditCardAuthorization $creditCardAuthorization
     * @param \StructType\AccountAuthorization $accountAuthorization
     * @param mixed $driversLicenseAuthorization
     * @param \StructType\BookingReferenceID $bookingReferenceID
     * @param string $principalCompanyCode
     * @param string $refNumber
     */
    public function __construct(\StructType\CheckAuthorization $checkAuthorization = null, \StructType\CreditCardAuthorization $creditCardAuthorization = null, \StructType\AccountAuthorization $accountAuthorization = null, $driversLicenseAuthorization = null, \StructType\BookingReferenceID $bookingReferenceID = null, $principalCompanyCode = null, $refNumber = null)
    {
        $this
            ->setCheckAuthorization($checkAuthorization)
            ->setCreditCardAuthorization($creditCardAuthorization)
            ->setAccountAuthorization($accountAuthorization)
            ->setDriversLicenseAuthorization($driversLicenseAuthorization)
            ->setBookingReferenceID($bookingReferenceID)
            ->setPrincipalCompanyCode($principalCompanyCode)
            ->setRefNumber($refNumber);
    }
    /**
     * Get CheckAuthorization value
     * @return \StructType\CheckAuthorization|null
     */
    public function getCheckAuthorization()
    {
        return isset($this->CheckAuthorization) ? $this->CheckAuthorization : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCheckAuthorization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckAuthorization method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCheckAuthorizationForChoiceConstraintsFromSetCheckAuthorization($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CreditCardAuthorization',
            'AccountAuthorization',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CheckAuthorization can\'t be set as the property %s is already set. Only one property must be set among these properties: CheckAuthorization, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CheckAuthorization value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CheckAuthorization $checkAuthorization
     * @return \StructType\AuthorizationType
     */
    public function setCheckAuthorization(\StructType\CheckAuthorization $checkAuthorization = null)
    {
        // validation for constraint: choice(CheckAuthorization, CreditCardAuthorization, AccountAuthorization)
        if ('' !== ($checkAuthorizationChoiceErrorMessage = self::validateCheckAuthorizationForChoiceConstraintsFromSetCheckAuthorization($checkAuthorization))) {
            throw new \InvalidArgumentException($checkAuthorizationChoiceErrorMessage, __LINE__);
        }
        if (is_null($checkAuthorization) || (is_array($checkAuthorization) && empty($checkAuthorization))) {
            unset($this->CheckAuthorization);
        } else {
            $this->CheckAuthorization = $checkAuthorization;
        }
        return $this;
    }
    /**
     * Get CreditCardAuthorization value
     * @return \StructType\CreditCardAuthorization|null
     */
    public function getCreditCardAuthorization()
    {
        return isset($this->CreditCardAuthorization) ? $this->CreditCardAuthorization : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCreditCardAuthorization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreditCardAuthorization method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCreditCardAuthorizationForChoiceConstraintsFromSetCreditCardAuthorization($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CheckAuthorization',
            'AccountAuthorization',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CreditCardAuthorization can\'t be set as the property %s is already set. Only one property must be set among these properties: CreditCardAuthorization, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CreditCardAuthorization value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CreditCardAuthorization $creditCardAuthorization
     * @return \StructType\AuthorizationType
     */
    public function setCreditCardAuthorization(\StructType\CreditCardAuthorization $creditCardAuthorization = null)
    {
        // validation for constraint: choice(CheckAuthorization, CreditCardAuthorization, AccountAuthorization)
        if ('' !== ($creditCardAuthorizationChoiceErrorMessage = self::validateCreditCardAuthorizationForChoiceConstraintsFromSetCreditCardAuthorization($creditCardAuthorization))) {
            throw new \InvalidArgumentException($creditCardAuthorizationChoiceErrorMessage, __LINE__);
        }
        if (is_null($creditCardAuthorization) || (is_array($creditCardAuthorization) && empty($creditCardAuthorization))) {
            unset($this->CreditCardAuthorization);
        } else {
            $this->CreditCardAuthorization = $creditCardAuthorization;
        }
        return $this;
    }
    /**
     * Get AccountAuthorization value
     * @return \StructType\AccountAuthorization|null
     */
    public function getAccountAuthorization()
    {
        return isset($this->AccountAuthorization) ? $this->AccountAuthorization : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccountAuthorization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountAuthorization method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccountAuthorizationForChoiceConstraintsFromSetAccountAuthorization($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CheckAuthorization',
            'CreditCardAuthorization',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AccountAuthorization can\'t be set as the property %s is already set. Only one property must be set among these properties: AccountAuthorization, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AccountAuthorization value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountAuthorization $accountAuthorization
     * @return \StructType\AuthorizationType
     */
    public function setAccountAuthorization(\StructType\AccountAuthorization $accountAuthorization = null)
    {
        // validation for constraint: choice(CheckAuthorization, CreditCardAuthorization, AccountAuthorization)
        if ('' !== ($accountAuthorizationChoiceErrorMessage = self::validateAccountAuthorizationForChoiceConstraintsFromSetAccountAuthorization($accountAuthorization))) {
            throw new \InvalidArgumentException($accountAuthorizationChoiceErrorMessage, __LINE__);
        }
        if (is_null($accountAuthorization) || (is_array($accountAuthorization) && empty($accountAuthorization))) {
            unset($this->AccountAuthorization);
        } else {
            $this->AccountAuthorization = $accountAuthorization;
        }
        return $this;
    }
    /**
     * Get DriversLicenseAuthorization value
     * @return mixed|null
     */
    public function getDriversLicenseAuthorization()
    {
        return $this->DriversLicenseAuthorization;
    }
    /**
     * Set DriversLicenseAuthorization value
     * @param mixed $driversLicenseAuthorization
     * @return \StructType\AuthorizationType
     */
    public function setDriversLicenseAuthorization($driversLicenseAuthorization = null)
    {
        $this->DriversLicenseAuthorization = $driversLicenseAuthorization;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\BookingReferenceID|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param \StructType\BookingReferenceID $bookingReferenceID
     * @return \StructType\AuthorizationType
     */
    public function setBookingReferenceID(\StructType\BookingReferenceID $bookingReferenceID = null)
    {
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get PrincipalCompanyCode value
     * @return string|null
     */
    public function getPrincipalCompanyCode()
    {
        return $this->PrincipalCompanyCode;
    }
    /**
     * Set PrincipalCompanyCode value
     * @param string $principalCompanyCode
     * @return \StructType\AuthorizationType
     */
    public function setPrincipalCompanyCode($principalCompanyCode = null)
    {
        // validation for constraint: string
        if (!is_null($principalCompanyCode) && !is_string($principalCompanyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($principalCompanyCode, true), gettype($principalCompanyCode)), __LINE__);
        }
        $this->PrincipalCompanyCode = $principalCompanyCode;
        return $this;
    }
    /**
     * Get RefNumber value
     * @return string|null
     */
    public function getRefNumber()
    {
        return $this->RefNumber;
    }
    /**
     * Set RefNumber value
     * @param string $refNumber
     * @return \StructType\AuthorizationType
     */
    public function setRefNumber($refNumber = null)
    {
        // validation for constraint: string
        if (!is_null($refNumber) && !is_string($refNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNumber, true), gettype($refNumber)), __LINE__);
        }
        $this->RefNumber = $refNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
