<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attraction StructType
 * Meta information extracted from the WSDL
 * - documentation: This may be used to uniquely identify an attraction. | The CodeContext attribute allows for a reference to the external code table used as the source for the code. The Code is available to send code information for an attraction
 * (e.g. if the attraction is an airport, the actual airport code may be included). | This identifies an item of local interest (e.g. theme park, airport, museum, rail station, university).
 * @subpackage Structs
 */
class Attraction extends AbstractStructBase
{
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Contact
     */
    public $Contact;
    /**
     * The OperationSchedules
     * Meta information extracted from the WSDL
     * - documentation: Operating schedules for the attraction.
     * - minOccurs: 0
     * @var mixed
     */
    public $OperationSchedules;
    /**
     * The MultimediaDescriptions
     * Meta information extracted from the WSDL
     * - documentation: Multimedia information about the attraction.
     * - minOccurs: 0
     * @var mixed
     */
    public $MultimediaDescriptions;
    /**
     * The RefPoints
     * Meta information extracted from the WSDL
     * - documentation: Information about the location of the attraction.
     * - minOccurs: 0
     * @var mixed
     */
    public $RefPoints;
    /**
     * The DescriptiveText
     * Meta information extracted from the WSDL
     * - documentation: Descriptive text that describes the attraction.
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The AttractionCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: The code for the type of attraction in the proximity of the hotel facility. Refer to OpenTravel Code List Attraction Category Code (ACC).
     * - use: optional
     * @var string
     */
    public $AttractionCategoryCode;
    /**
     * The AttractionName
     * Meta information extracted from the WSDL
     * - documentation: The name of the local attraction.
     * - use: optional
     * @var string
     */
    public $AttractionName;
    /**
     * The AttractionFee
     * Meta information extracted from the WSDL
     * - documentation: A guideline price if there is a fee associated with the attraction.
     * - use: optional
     * @var float
     */
    public $AttractionFee;
    /**
     * The CourtesyPhone
     * Meta information extracted from the WSDL
     * - documentation: This signifies whether or not a courtesy phone for contacting the hotel is available at the attraction (e.g. often times these are availabe in airports). When true, the phone is available.
     * - use: optional
     * @var bool
     */
    public $CourtesyPhone;
    /**
     * The ProximityCode
     * Meta information extracted from the WSDL
     * - documentation: Denotes whether a service is onsite, offsite or information is not available. Refer to OpenTravel Code Table Proximity (PRX).
     * - use: optional
     * @var string
     */
    public $ProximityCode;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - documentation: Used to define the display order.
     * - use: optional
     * @var int
     */
    public $Sort;
    /**
     * The MinAgeAppropriateCode
     * Meta information extracted from the WSDL
     * - documentation: Minimum age the attraction is appropriate for. Refer to OpenTravel Code List Age Qualifying Code (AQC).
     * - use: optional
     * @var string
     */
    public $MinAgeAppropriateCode;
    /**
     * The ApplicableStart
     * Meta information extracted from the WSDL
     * - documentation: Start month and day or date for which the attraction (e.g. the start of a season) is available. When a year is not used (i.e. only the month and day) it signifies a recurring season.
     * - use: optional
     * @var string
     */
    public $ApplicableStart;
    /**
     * The ApplicableEnd
     * Meta information extracted from the WSDL
     * - documentation: End month and day or date for which the attraction (e.g. the end of a season) is available. When a year is not used (i.e. only the month and day) it signifies a recurring season.
     * - use: optional
     * @var string
     */
    public $ApplicableEnd;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Identifies the language in which the attraction information is sent.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * Constructor method for Attraction
     * @uses Attraction::setContact()
     * @uses Attraction::setOperationSchedules()
     * @uses Attraction::setMultimediaDescriptions()
     * @uses Attraction::setRefPoints()
     * @uses Attraction::setDescriptiveText()
     * @uses Attraction::setAttractionCategoryCode()
     * @uses Attraction::setAttractionName()
     * @uses Attraction::setAttractionFee()
     * @uses Attraction::setCourtesyPhone()
     * @uses Attraction::setProximityCode()
     * @uses Attraction::setSort()
     * @uses Attraction::setMinAgeAppropriateCode()
     * @uses Attraction::setApplicableStart()
     * @uses Attraction::setApplicableEnd()
     * @uses Attraction::setLanguage()
     * @param \StructType\Contact $contact
     * @param mixed $operationSchedules
     * @param mixed $multimediaDescriptions
     * @param mixed $refPoints
     * @param string $descriptiveText
     * @param string $attractionCategoryCode
     * @param string $attractionName
     * @param float $attractionFee
     * @param bool $courtesyPhone
     * @param string $proximityCode
     * @param int $sort
     * @param string $minAgeAppropriateCode
     * @param string $applicableStart
     * @param string $applicableEnd
     * @param string $language
     */
    public function __construct(\StructType\Contact $contact = null, $operationSchedules = null, $multimediaDescriptions = null, $refPoints = null, $descriptiveText = null, $attractionCategoryCode = null, $attractionName = null, $attractionFee = null, $courtesyPhone = null, $proximityCode = null, $sort = null, $minAgeAppropriateCode = null, $applicableStart = null, $applicableEnd = null, $language = null)
    {
        $this
            ->setContact($contact)
            ->setOperationSchedules($operationSchedules)
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setRefPoints($refPoints)
            ->setDescriptiveText($descriptiveText)
            ->setAttractionCategoryCode($attractionCategoryCode)
            ->setAttractionName($attractionName)
            ->setAttractionFee($attractionFee)
            ->setCourtesyPhone($courtesyPhone)
            ->setProximityCode($proximityCode)
            ->setSort($sort)
            ->setMinAgeAppropriateCode($minAgeAppropriateCode)
            ->setApplicableStart($applicableStart)
            ->setApplicableEnd($applicableEnd)
            ->setLanguage($language);
    }
    /**
     * Get Contact value
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\Contact $contact
     * @return \StructType\Attraction
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get OperationSchedules value
     * @return mixed|null
     */
    public function getOperationSchedules()
    {
        return $this->OperationSchedules;
    }
    /**
     * Set OperationSchedules value
     * @param mixed $operationSchedules
     * @return \StructType\Attraction
     */
    public function setOperationSchedules($operationSchedules = null)
    {
        $this->OperationSchedules = $operationSchedules;
        return $this;
    }
    /**
     * Get MultimediaDescriptions value
     * @return mixed|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param mixed $multimediaDescriptions
     * @return \StructType\Attraction
     */
    public function setMultimediaDescriptions($multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get RefPoints value
     * @return mixed|null
     */
    public function getRefPoints()
    {
        return $this->RefPoints;
    }
    /**
     * Set RefPoints value
     * @param mixed $refPoints
     * @return \StructType\Attraction
     */
    public function setRefPoints($refPoints = null)
    {
        $this->RefPoints = $refPoints;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \StructType\Attraction
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptiveText, true), gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get AttractionCategoryCode value
     * @return string|null
     */
    public function getAttractionCategoryCode()
    {
        return $this->AttractionCategoryCode;
    }
    /**
     * Set AttractionCategoryCode value
     * @param string $attractionCategoryCode
     * @return \StructType\Attraction
     */
    public function setAttractionCategoryCode($attractionCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($attractionCategoryCode) && !is_string($attractionCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attractionCategoryCode, true), gettype($attractionCategoryCode)), __LINE__);
        }
        $this->AttractionCategoryCode = $attractionCategoryCode;
        return $this;
    }
    /**
     * Get AttractionName value
     * @return string|null
     */
    public function getAttractionName()
    {
        return $this->AttractionName;
    }
    /**
     * Set AttractionName value
     * @param string $attractionName
     * @return \StructType\Attraction
     */
    public function setAttractionName($attractionName = null)
    {
        // validation for constraint: string
        if (!is_null($attractionName) && !is_string($attractionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attractionName, true), gettype($attractionName)), __LINE__);
        }
        $this->AttractionName = $attractionName;
        return $this;
    }
    /**
     * Get AttractionFee value
     * @return float|null
     */
    public function getAttractionFee()
    {
        return $this->AttractionFee;
    }
    /**
     * Set AttractionFee value
     * @param float $attractionFee
     * @return \StructType\Attraction
     */
    public function setAttractionFee($attractionFee = null)
    {
        // validation for constraint: float
        if (!is_null($attractionFee) && !(is_float($attractionFee) || is_numeric($attractionFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($attractionFee, true), gettype($attractionFee)), __LINE__);
        }
        $this->AttractionFee = $attractionFee;
        return $this;
    }
    /**
     * Get CourtesyPhone value
     * @return bool|null
     */
    public function getCourtesyPhone()
    {
        return $this->CourtesyPhone;
    }
    /**
     * Set CourtesyPhone value
     * @param bool $courtesyPhone
     * @return \StructType\Attraction
     */
    public function setCourtesyPhone($courtesyPhone = null)
    {
        // validation for constraint: boolean
        if (!is_null($courtesyPhone) && !is_bool($courtesyPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($courtesyPhone, true), gettype($courtesyPhone)), __LINE__);
        }
        $this->CourtesyPhone = $courtesyPhone;
        return $this;
    }
    /**
     * Get ProximityCode value
     * @return string|null
     */
    public function getProximityCode()
    {
        return $this->ProximityCode;
    }
    /**
     * Set ProximityCode value
     * @param string $proximityCode
     * @return \StructType\Attraction
     */
    public function setProximityCode($proximityCode = null)
    {
        // validation for constraint: string
        if (!is_null($proximityCode) && !is_string($proximityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proximityCode, true), gettype($proximityCode)), __LINE__);
        }
        $this->ProximityCode = $proximityCode;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\Attraction
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get MinAgeAppropriateCode value
     * @return string|null
     */
    public function getMinAgeAppropriateCode()
    {
        return $this->MinAgeAppropriateCode;
    }
    /**
     * Set MinAgeAppropriateCode value
     * @param string $minAgeAppropriateCode
     * @return \StructType\Attraction
     */
    public function setMinAgeAppropriateCode($minAgeAppropriateCode = null)
    {
        // validation for constraint: string
        if (!is_null($minAgeAppropriateCode) && !is_string($minAgeAppropriateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minAgeAppropriateCode, true), gettype($minAgeAppropriateCode)), __LINE__);
        }
        $this->MinAgeAppropriateCode = $minAgeAppropriateCode;
        return $this;
    }
    /**
     * Get ApplicableStart value
     * @return string|null
     */
    public function getApplicableStart()
    {
        return $this->ApplicableStart;
    }
    /**
     * Set ApplicableStart value
     * @param string $applicableStart
     * @return \StructType\Attraction
     */
    public function setApplicableStart($applicableStart = null)
    {
        // validation for constraint: string
        if (!is_null($applicableStart) && !is_string($applicableStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableStart, true), gettype($applicableStart)), __LINE__);
        }
        $this->ApplicableStart = $applicableStart;
        return $this;
    }
    /**
     * Get ApplicableEnd value
     * @return string|null
     */
    public function getApplicableEnd()
    {
        return $this->ApplicableEnd;
    }
    /**
     * Set ApplicableEnd value
     * @param string $applicableEnd
     * @return \StructType\Attraction
     */
    public function setApplicableEnd($applicableEnd = null)
    {
        // validation for constraint: string
        if (!is_null($applicableEnd) && !is_string($applicableEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableEnd, true), gettype($applicableEnd)), __LINE__);
        }
        $this->ApplicableEnd = $applicableEnd;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\Attraction
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attraction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
